/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.testtools.selenium;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import org.kuali.rice.testtools.selenium.WebDriverUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WebDriverHighlightHelper {
    protected boolean jsHighlightEnabled = false;
    public static final String JS_HIGHLIGHT_BACKGROUND = "#66FF33";
    public static final String JS_HIGHLIGHT_BOARDER = "#66FF33";
    public static final int JS_HIGHLIGHT_MS = 400;
    public static final String JS_HIGHLIGHT_MS_PROPERTY = "remote.driver.highlight.ms";
    public static final String JS_HIGHLIGHT_PROPERTY = "remote.driver.highlight";
    public static final String JS_HIGHLIGHT_INPUT_PROPERTY = "remote.driver.highlight.input";

    public WebDriverHighlightHelper() {
        if ("true".equals(System.getProperty(JS_HIGHLIGHT_PROPERTY, "false"))) {
            this.jsHighlightEnabled = true;
            if (System.getProperty(JS_HIGHLIGHT_INPUT_PROPERTY) != null) {
                InputStream in = WebDriverUtils.class.getResourceAsStream(System.getProperty(JS_HIGHLIGHT_INPUT_PROPERTY));
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String line = null;
                LinkedList<String> lines = new LinkedList<String>();
                try {
                    while ((line = reader.readLine()) != null) {
                        lines.add(line);
                    }
                }
                catch (IOException e) {
                    System.out.println("Error reading javascript highlight playback file " + System.getProperty(JS_HIGHLIGHT_INPUT_PROPERTY));
                    e.printStackTrace();
                }
            }
        }
    }

    public void highlightElement(WebDriver webDriver, WebElement webElement) {
        if (this.jsHighlightEnabled && webElement != null) {
            try {
                JavascriptExecutor js = (JavascriptExecutor)webDriver;
                String jsHighlight = "element = arguments[0];\noriginalStyle = element.getAttribute('style');\nelement.setAttribute('style', originalStyle + \"; background: #66FF33; border: 2px solid #66FF33;\");\nsetTimeout(function(){\n    element.setAttribute('style', originalStyle);\n}, " + System.getProperty(JS_HIGHLIGHT_MS_PROPERTY, "400") + ");";
                js.executeScript(jsHighlight, new Object[]{webElement});
            }
            catch (Throwable t) {
                System.out.println("Throwable during javascript highlight element");
                t.printStackTrace();
            }
        }
    }
}

