/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.testtools.selenium;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.kuali.rice.testtools.selenium.AutomatedFunctionalTestUtils;
import org.kuali.rice.testtools.selenium.SauceLabsWebDriverHelper;
import org.kuali.rice.testtools.selenium.WebDriverHighlightHelper;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriver;

public class WebDriverUtils {
    protected static SauceLabsWebDriverHelper saucelabs;
    protected static WebDriverHighlightHelper webDriverHighlightHelper;
    public static boolean jGrowlEnabled;
    public static final String DEFAULT_BASE_URL = "http://localhost:8080/kr-dev";
    public static final String DEFAULT_BASE_URL_KRAD = "http://localhost:8080/krad-dev";
    public static final String DONT_TEAR_DOWN_PROPERTY = "remote.driver.dontTearDown";
    public static final String DONT_TEAR_DOWN_ON_FAILURE_PROPERTY = "remote.driver.dontTearDownOnFailure";
    public static final String HUB_DRIVER_PROPERTY = "remote.public.driver";
    public static final String HUB_PROPERTY = "remote.public.hub";
    public static final String HUB_URL_PROPERTY = "http://localhost:4444/wd/hub";
    public static int IMPLICIT_WAIT_TIME_LOOP_MS;
    public static int IMPLICIT_WAIT_TIME_SECONDS_DEFAULT;
    public static final boolean JGROWL_ERROR_FAILURE = false;
    public static final String PROXY_HOST_PROPERTY = "remote.public.proxy";
    public static final String REMOTE_AUTOLOGIN_PROPERTY = "remote.autologin";
    public static final String REMOTE_JGROWL_ENABLED = "remote.jgrowl.enabled";
    public static final String REMOTE_LOGIN_UIF = "remote.login.uif";
    public static final String REMOTE_PROPERTIES_PROPERTY = "remote.property.file";
    public static final String REMOTE_PUBLIC_CHROME = "remote.public.chrome";
    public static final String REMOTE_PUBLIC_URL_PROPERTY = "remote.public.url";
    public static final String REMOTE_PUBLIC_WAIT_SECONDS_PROPERTY = "remote.public.wait.seconds";
    public static final String REMOTE_PUBLIC_USER_PROPERTY = "remote.public.user";
    public static final String REMOTE_PUBLIC_USERPOOL_PROPERTY = "remote.public.userpool";
    public static final int SETUP_URL_LOAD_WAIT_SECONDS = 120;
    public static final String WEBDRIVER_CHROME_DRIVER = "webdriver.chrome.driver";

    public static WebDriver setUp(String className, String testName) throws Exception {
        if ("true".equals(System.getProperty(REMOTE_JGROWL_ENABLED, "false"))) {
            jGrowlEnabled = true;
        }
        webDriverHighlightHelper = new WebDriverHighlightHelper();
        WebDriver driver = null;
        if (System.getProperty("remote.driver.saucelabs") == null) {
            driver = WebDriverUtils.getWebDriver();
        } else {
            saucelabs = new SauceLabsWebDriverHelper();
            saucelabs.setUp(className, testName);
            driver = saucelabs.getDriver();
        }
        return driver;
    }

    public static void tearDown(boolean passed, String sessionId, String poolParamTest, String poolParamUser, String className, String testName) throws Exception {
        if (passed) {
            System.out.println("Registering session passed " + sessionId);
        } else {
            System.out.println("Registering session failed " + sessionId);
        }
        if (System.getProperty("remote.driver.saucelabs") != null) {
            saucelabs.tearDown(passed, sessionId, className, testName);
        }
        if (System.getProperty(REMOTE_PUBLIC_USERPOOL_PROPERTY) != null) {
            AutomatedFunctionalTestUtils.getHTML(AutomatedFunctionalTestUtils.prettyHttp(System.getProperty(REMOTE_PUBLIC_USERPOOL_PROPERTY) + "?test=" + poolParamTest + "&user=" + poolParamUser));
        }
    }

    public static void acceptAlertIfPresent(WebDriver driver) {
        if (WebDriverUtils.isAlertPresent(driver)) {
            System.out.println("Alert present " + WebDriverUtils.alertText(driver));
            try {
                WebDriverUtils.alertAccept(driver);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void alertAccept(WebDriver driver) {
        Alert alert = driver.switchTo().alert();
        WebDriverUtils.jGrowl(driver, "AFT Step", false, "AFT Step: Accept Alert " + WebDriverUtils.alertText(driver));
        alert.accept();
    }

    public static void alertDismiss(WebDriver driver) {
        Alert alert = driver.switchTo().alert();
        WebDriverUtils.jGrowl(driver, "AFT Step", false, "AFT Step: Dismiss Alert " + WebDriverUtils.alertText(driver));
        alert.dismiss();
    }

    public static String alertText(WebDriver driver) {
        return driver.switchTo().alert().getText();
    }

    public static ChromeDriverService chromeDriverCreateCheck() {
        String driverParam = System.getProperty(HUB_DRIVER_PROPERTY);
        if (driverParam != null && "chrome".equals(driverParam.toLowerCase())) {
            if (System.getProperty(WEBDRIVER_CHROME_DRIVER) == null && System.getProperty(REMOTE_PUBLIC_CHROME) != null) {
                System.setProperty(WEBDRIVER_CHROME_DRIVER, System.getProperty(REMOTE_PUBLIC_CHROME));
            }
            try {
                ChromeDriverService chromeDriverService = (ChromeDriverService)((ChromeDriverService.Builder)((ChromeDriverService.Builder)new ChromeDriverService.Builder().usingDriverExecutable(new File(System.getProperty(WEBDRIVER_CHROME_DRIVER)))).usingAnyFreePort()).build();
                return chromeDriverService;
            }
            catch (Throwable t) {
                throw new RuntimeException("Exception starting chrome driver service, is chromedriver ( http://code.google.com/p/chromedriver/downloads/list ) installed? You can include the path to it using -Dremote.public.chrome", t);
            }
        }
        return null;
    }

    public static int configuredImplicityWait() {
        return Integer.parseInt(System.getProperty(REMOTE_PUBLIC_WAIT_SECONDS_PROPERTY, IMPLICIT_WAIT_TIME_SECONDS_DEFAULT + ""));
    }

    public static String deLinespace(String contents) {
        while (contents.contains("\n\n")) {
            contents = contents.replaceAll("\n\n", "\n");
        }
        return contents;
    }

    public static String determineUser(String testParam) {
        String user = null;
        if (System.getProperty(REMOTE_PUBLIC_USER_PROPERTY) != null) {
            return System.getProperty(REMOTE_PUBLIC_USER_PROPERTY);
        }
        if (System.getProperty(REMOTE_PUBLIC_USERPOOL_PROPERTY) != null) {
            String userResponse = AutomatedFunctionalTestUtils.getHTML(AutomatedFunctionalTestUtils.prettyHttp(System.getProperty(REMOTE_PUBLIC_USERPOOL_PROPERTY) + "?test=" + testParam.trim()));
            return userResponse.substring(userResponse.lastIndexOf(":") + 2, userResponse.lastIndexOf("\""));
        }
        return user;
    }

    public static boolean dontTearDownPropertyNotSet() {
        return System.getProperty(DONT_TEAR_DOWN_PROPERTY) == null || "f".startsWith(System.getProperty(DONT_TEAR_DOWN_PROPERTY).toLowerCase()) || "n".startsWith(System.getProperty(DONT_TEAR_DOWN_PROPERTY).toLowerCase());
    }

    public static boolean dontTearDownOnFailure(boolean passed) {
        if (!"n".equalsIgnoreCase(System.getProperty(DONT_TEAR_DOWN_ON_FAILURE_PROPERTY, "n"))) {
            return passed;
        }
        return true;
    }

    public static WebElement findButtonByText(WebDriver driver, String buttonText) {
        return WebDriverUtils.findElement(driver, By.xpath((String)("//button[contains(text(), '" + buttonText + "')]")));
    }

    public static WebElement findElement(WebDriver driver, By by) {
        WebElement found = driver.findElement(by);
        WebDriverUtils.highlightElement(driver, found);
        return found;
    }

    public static String getBaseUrlString() {
        String baseUrl = System.getProperty(REMOTE_PUBLIC_URL_PROPERTY);
        if (baseUrl == null) {
            baseUrl = DEFAULT_BASE_URL;
        }
        baseUrl = AutomatedFunctionalTestUtils.prettyHttp(baseUrl);
        return baseUrl;
    }

    public static String getDateTimeStampFormatted() {
        Date now = Calendar.getInstance().getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        return sdf.format(now);
    }

    public static WebElement getElementByAttributeValue(WebDriver driver, String attributeName, String value) {
        return WebDriverUtils.findElement(driver, By.cssSelector((String)("[" + attributeName + "='" + value + "']")));
    }

    public static String getHubUrlString() {
        String hubUrl = System.getProperty(HUB_PROPERTY);
        if (hubUrl == null) {
            hubUrl = HUB_URL_PROPERTY;
        }
        if (!(hubUrl = AutomatedFunctionalTestUtils.prettyHttp(hubUrl)).endsWith("/wd/hub")) {
            hubUrl = hubUrl + "/wd/hub";
        }
        return hubUrl;
    }

    public static WebDriver getWebDriver() {
        String driverParam = System.getProperty(HUB_DRIVER_PROPERTY);
        String hubParam = System.getProperty(HUB_PROPERTY);
        String proxyParam = System.getProperty(PROXY_HOST_PROPERTY);
        DesiredCapabilities capabilities = new DesiredCapabilities();
        Object webDriver = null;
        if (StringUtils.isNotEmpty((String)proxyParam)) {
            capabilities.setCapability("proxy", (Object)new Proxy().setHttpProxy(proxyParam));
        }
        if (hubParam == null) {
            if (driverParam == null || "firefox".equalsIgnoreCase(driverParam)) {
                FirefoxProfile profile = new FirefoxProfile();
                profile.setEnableNativeEvents(false);
                capabilities.setCapability("firefox_profile", (Object)profile);
                return new FirefoxDriver((Capabilities)capabilities);
            }
            if ("chrome".equalsIgnoreCase(driverParam)) {
                return new ChromeDriver((Capabilities)capabilities);
            }
            if ("safari".equals(driverParam)) {
                System.out.println("SafariDriver probably won't work, if it does please contact Erik M.");
                return new SafariDriver((Capabilities)capabilities);
            }
        } else {
            try {
                if (driverParam == null || "firefox".equalsIgnoreCase(driverParam)) {
                    return new RemoteWebDriver(new URL(WebDriverUtils.getHubUrlString()), (Capabilities)DesiredCapabilities.firefox());
                }
                if ("chrome".equalsIgnoreCase(driverParam)) {
                    return new RemoteWebDriver(new URL(WebDriverUtils.getHubUrlString()), (Capabilities)DesiredCapabilities.chrome());
                }
            }
            catch (MalformedURLException mue) {
                System.out.println(WebDriverUtils.getHubUrlString() + " " + mue.getMessage());
                mue.printStackTrace();
            }
        }
        return null;
    }

    public static void highlightElement(WebDriver webDriver, By by) {
        List elements = webDriver.findElements(by);
        for (WebElement element : elements) {
            WebDriverUtils.highlightElement(webDriver, element);
        }
    }

    public static void highlightElements(WebDriver webDriver, List<WebElement> webElements) {
        for (WebElement webElement : webElements) {
            WebDriverUtils.highlightElement(webDriver, webElement);
        }
    }

    public static void highlightElement(WebDriver webDriver, WebElement webElement) {
        webDriverHighlightHelper.highlightElement(webDriver, webElement);
    }

    public static boolean isAlertPresent(WebDriver driver) {
        try {
            driver.switchTo().alert();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Boolean isTextPresent(WebDriver driver, String pageText, String text) {
        boolean textPresent = Boolean.FALSE;
        if (pageText.contains(text)) {
            WebDriverUtils.highlightElement(driver, By.xpath((String)("//*[contains(text(), '" + text + "')]")));
            textPresent = Boolean.TRUE;
        }
        WebDriverUtils.jGrowl(driver, "Is Text Present?", false, "Is text '" + text + "' present?" + " " + textPresent);
        return textPresent;
    }

    public static List javascriptErrors(WebDriver driver) {
        LinkedList errors = new LinkedList();
        if (driver == null) {
            System.out.println("WebDriver to use to retrieve javascript errors was null!");
            return errors;
        }
        try {
            String javascript = "return window.ALL_ERRORS;";
            List javascriptErrors = (List)((JavascriptExecutor)driver).executeScript(javascript, new Object[0]);
            if (javascriptErrors != null) {
                errors.addAll(javascriptErrors);
            }
        }
        catch (Throwable t) {
            System.out.println("Problem retrieving javascript errors: " + t.toString());
            t.printStackTrace(System.out);
        }
        return errors;
    }

    public static String javascriptErrorsToString(List errors) {
        StringBuilder sb = new StringBuilder();
        if (errors != null && errors.size() > 0) {
            for (Object error : errors) {
                sb.append((String)error).append("\n");
            }
        }
        return sb.toString();
    }

    public static void jGrowl(WebDriver driver, String jGrowlHeader, boolean sticky, String message, Throwable throwable) {
        if (jGrowlEnabled) {
            WebDriverUtils.jGrowl(driver, jGrowlHeader, sticky, message + " " + throwable.getMessage() + "\n" + ExceptionUtils.getStackTrace((Throwable)throwable));
        }
    }

    public static void jGrowl(WebDriver driver, String jGrowlHeader, boolean sticky, String message) {
        WebDriverUtils.stepMessage(message);
        message = message.replace("'", "&#39;");
        message = message.replace("\"", "&quot;");
        if (jGrowlEnabled) {
            String javascript = "jQuery.jGrowl('" + message + "' , {sticky: " + sticky + ", header : '" + jGrowlHeader + "'});";
            try {
                ((JavascriptExecutor)driver).executeScript(javascript, new Object[0]);
            }
            catch (Throwable t) {
                WebDriverUtils.jGrowlException(t, javascript);
            }
        }
    }

    public static void jGrowlException(Throwable throwable, String jGrowlJavascript) {
        String failMessage = jGrowlJavascript + " failed with " + throwable.getMessage() + "\n" + ExceptionUtils.getStackTrace((Throwable)throwable);
        System.out.println("jGrowl failure " + failMessage);
    }

    public static void openTestUrl(WebDriver driver, String testUrl) {
        driver.manage().timeouts().implicitlyWait(120L, TimeUnit.SECONDS);
        driver.get(testUrl);
        if (!System.getProperty("saucelabs.browser", "ff").equals("opera")) {
            driver.manage().window().maximize();
        }
        WebDriverUtils.jGrowl(driver, "Open URL", false, "Open " + testUrl);
        driver.manage().timeouts().implicitlyWait((long)WebDriverUtils.configuredImplicityWait(), TimeUnit.SECONDS);
    }

    public static void selectFrameSafe(WebDriver driver, String locator) {
        try {
            driver.switchTo().frame(locator);
        }
        catch (NoSuchFrameException noSuchFrameException) {
            // empty catch block
        }
    }

    public static void stepMessage(String message) {
        System.out.println("AFT Step: " + message);
    }

    public static WebElement waitAndGetElementByAttributeValue(WebDriver driver, String attribute, String attributeValue, int waitSeconds) throws InterruptedException {
        driver.manage().timeouts().implicitlyWait(1L, TimeUnit.SECONDS);
        boolean failed = false;
        int second = 0;
        while (true) {
            Thread.sleep(1000L);
            if (second >= waitSeconds) {
                failed = true;
            }
            try {
                if (failed || WebDriverUtils.getElementByAttributeValue(driver, attribute, attributeValue) != null) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++second;
        }
        WebElement element = WebDriverUtils.getElementByAttributeValue(driver, attribute, attributeValue);
        driver.manage().timeouts().implicitlyWait((long)WebDriverUtils.configuredImplicityWait(), TimeUnit.SECONDS);
        return element;
    }

    public static void waitToAcceptAlert(WebDriver driver, int waitSeconds, String message) throws InterruptedException {
        driver.manage().timeouts().implicitlyWait((long)IMPLICIT_WAIT_TIME_LOOP_MS, TimeUnit.MILLISECONDS);
        boolean failed = false;
        int second = 0;
        while (true) {
            Thread.sleep(1000L);
            if (second >= waitSeconds) {
                failed = true;
            }
            try {
                if (failed) break;
                if (WebDriverUtils.isAlertPresent(driver)) {
                    WebDriverUtils.acceptAlertIfPresent(driver);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++second;
        }
        driver.manage().timeouts().implicitlyWait((long)WebDriverUtils.configuredImplicityWait(), TimeUnit.SECONDS);
    }

    public static WebElement waitFor(WebDriver driver, int waitSeconds, By by, String message) throws InterruptedException {
        driver.manage().timeouts().implicitlyWait((long)IMPLICIT_WAIT_TIME_LOOP_MS, TimeUnit.MILLISECONDS);
        boolean failed = false;
        WebElement element = null;
        int second = 0;
        while (true) {
            Thread.sleep(1000L);
            if (second >= waitSeconds) {
                failed = true;
            }
            try {
                if (failed) break;
                if (driver.findElements(by).size() > 0) {
                    element = WebDriverUtils.findElement(driver, by);
                    WebDriverUtils.highlightElement(driver, element);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++second;
        }
        driver.manage().timeouts().implicitlyWait((long)WebDriverUtils.configuredImplicityWait(), TimeUnit.SECONDS);
        return element;
    }

    public static List<WebElement> waitFors(WebDriver driver, By by) throws InterruptedException {
        return WebDriverUtils.waitFors(driver, WebDriverUtils.configuredImplicityWait(), by, "");
    }

    public static List<WebElement> waitFors(WebDriver driver, By by, String message) throws InterruptedException {
        return WebDriverUtils.waitFors(driver, WebDriverUtils.configuredImplicityWait(), by, message);
    }

    public static List<WebElement> waitFors(WebDriver driver, int waitSeconds, By by, String message) throws InterruptedException {
        driver.manage().timeouts().implicitlyWait((long)IMPLICIT_WAIT_TIME_LOOP_MS, TimeUnit.MILLISECONDS);
        boolean failed = false;
        int second = 0;
        while (true) {
            Thread.sleep(1000L);
            if (second >= waitSeconds) {
                failed = true;
            }
            try {
                if (failed || driver.findElements(by).size() > 0) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++second;
        }
        driver.manage().timeouts().implicitlyWait((long)WebDriverUtils.configuredImplicityWait(), TimeUnit.SECONDS);
        return driver.findElements(by);
    }

    static {
        jGrowlEnabled = false;
        IMPLICIT_WAIT_TIME_LOOP_MS = 1000;
        IMPLICIT_WAIT_TIME_SECONDS_DEFAULT = 30;
    }
}

