/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.web.health;

import com.codahale.metrics.health.HealthCheck;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.web.health.DatabaseConnectionHealthGauge;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.dao.DataAccessException;

@RunWith(value=MockitoJUnitRunner.class)
public class DatabaseConnectionHealthGaugeTest {
    private DatabaseConnectionHealthGauge gauge;
    @Mock
    private DataSource dataSource;
    @Mock
    private DatabasePlatform platform;

    @Before
    public void setUp() {
        this.gauge = new DatabaseConnectionHealthGauge(this.dataSource, this.platform);
        this.stubValidationQuery(this.platform);
    }

    @Test
    public void testCheck_Healthy() throws Exception {
        Statement statement = this.stubSuccessfulQueryExecution(this.dataSource);
        HealthCheck.Result result = this.gauge.check();
        Assert.assertTrue((String)"Result should be healthy", (boolean)result.isHealthy());
        ((Statement)Mockito.verify((Object)statement)).execute(this.platform.getValidationQuery());
    }

    @Test(expected=DataAccessException.class)
    public void testCheck_Unhealthy() throws Exception {
        Statement statement = this.stubSQLException(this.dataSource);
        try {
            this.gauge.check();
        }
        finally {
            ((Statement)Mockito.verify((Object)statement)).execute(this.platform.getValidationQuery());
        }
    }

    @Test
    public void testGetValue_Healthy() throws Exception {
        Statement statement = this.stubSuccessfulQueryExecution(this.dataSource);
        Assert.assertTrue((String)"Get value should return true since db connection check is healthy", (boolean)this.gauge.getValue());
        ((Statement)Mockito.verify((Object)statement)).execute(this.platform.getValidationQuery());
    }

    @Test
    public void testGetValue_Unhealthy_Exception() throws Exception {
        Statement statement = this.stubSQLException(this.dataSource);
        Assert.assertFalse((String)"Get value should return false since db connection check throw a SQLException", (boolean)this.gauge.getValue());
        ((Statement)Mockito.verify((Object)statement)).execute(this.platform.getValidationQuery());
    }

    private void stubValidationQuery(DatabasePlatform platform) {
        Mockito.when((Object)platform.getValidationQuery()).thenReturn((Object)"select 1");
        Assert.assertEquals((Object)"select 1", (Object)platform.getValidationQuery());
    }

    private Statement stubSuccessfulQueryExecution(DataSource dataSource) throws SQLException {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)dataSource.getConnection()).thenReturn((Object)connection);
        Statement statement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)connection.createStatement()).thenReturn((Object)statement);
        return statement;
    }

    private Statement stubSQLException(DataSource dataSource) throws SQLException {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)dataSource.getConnection()).thenReturn((Object)connection);
        Statement statement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)connection.createStatement()).thenReturn((Object)statement);
        Mockito.when((Object)statement.execute(Matchers.anyString())).thenThrow(new Throwable[]{new SQLException("Failed to execute sql")});
        return statement;
    }
}

