/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.web.health;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Bucket;
import com.codahale.metrics.health.HealthCheck;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.web.health.AmazonS3ConnectionHealthGauge;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AmazonS3ConnectionHealthGaugeTest {
    private AmazonS3ConnectionHealthGauge gauge;
    @Mock
    private AmazonS3 amazonS3;

    @Before
    public void setUp() {
        this.gauge = new AmazonS3ConnectionHealthGauge(this.amazonS3);
    }

    @Test
    public void testCheck_Healthy() throws Exception {
        this.stubListBuckets(this.amazonS3, 1);
        HealthCheck.Result result = this.gauge.check();
        Assert.assertTrue((String)"Result should be healthy", (boolean)result.isHealthy());
    }

    @Test
    public void testCheck_Unhealthy() throws Exception {
        this.stubListBuckets(this.amazonS3, 0);
        HealthCheck.Result result = this.gauge.check();
        Assert.assertFalse((String)"Result should be unhealthy", (boolean)result.isHealthy());
        Assert.assertNotNull((String)"Result should have a message", (Object)result.getMessage());
    }

    @Test
    public void testGetValue_Healthy() throws Exception {
        this.stubListBuckets(this.amazonS3, 1);
        Assert.assertTrue((String)"Get value should return true since S3 check is healthy", (boolean)this.gauge.getValue());
    }

    @Test
    public void testGetValue_Unhealthy_NoBuckets() throws Exception {
        this.stubListBuckets(this.amazonS3, 0);
        Assert.assertFalse((String)"Get value should return false since S3 check is unhealthy", (boolean)this.gauge.getValue());
    }

    @Test
    public void testGetValue_Unhealthy_Exception() throws Exception {
        Mockito.when((Object)this.amazonS3.listBuckets()).thenThrow(new Throwable[]{new AmazonServiceException("Failed to contact S3")});
        Assert.assertFalse((String)"Get value should return false since S3 check threw exception", (boolean)this.gauge.getValue());
    }

    private void stubListBuckets(AmazonS3 amazonS3, int numBuckets) {
        ArrayList<Object> buckets = new ArrayList<Object>();
        for (int i = 0; i < numBuckets; ++i) {
            buckets.add(Mockito.mock(Bucket.class));
        }
        Mockito.when((Object)amazonS3.listBuckets()).thenReturn(buckets);
    }
}

