<%--
  #%L
  %%
  Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<%@ attribute name="forceOpen" required="true" description="Whether the hidden tab should be considered open or not." %>


<%-- maintain tabstate --%>
<%--   getTabStateJstl call is *required*, since it changes the currentTabIndex as a side-effect --%>
<%--   (which also means that I must retrieve currentTabIndex before retrieving tabStateJstl) --%>
<c:set var="currentTabIndex" value="${KualiForm.currentTabIndex}"/>
<!--  Ideally the tabKey should be the tabTitle, but since this is a hidden tab, I don't know what its title should be -->
<c:set var="tabKey" value="hiddenTabTitle"/>
<!--  hit form method to increment tab index -->
<c:set var="dummyIncrementer" value="${kfunc:incrementTabIndex(KualiForm, tabKey)}" />

<c:set var="currentTab" value="${kfunc:getTabState(KualiForm, tabKey)}"/>

<html:hidden property="tabStates(${tabKey}).open" value="${forceOpen}" />

<%-- display tab contents --%>
<jsp:doBody/>            
