<#--
 #%L
 %%
 Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#--
    Element that creates a table element and then invokes datatables to complete
    the table based on configured source data
 -->

<#macro uif_dataTable element>

    <#if element.styleClassesAsString?has_content>
        <#local styleClass="class=\"${element.styleClassesAsString}\""/>
    </#if>

    <#if element.style?has_content>
        <#local style="style=\"${element.style}\""/>
    </#if>

    <table id="${element.id}" ${style!} ${styleClass!}>
    </table>

    <@krad.script value="createTable('${element.id}', ${element.richTable.templateOptionsJSString}); "/>

</#macro>
