<%--
  #%L
  %%
  Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<c:set var="groupAttributes" value="${DataDictionary.GroupBo.attributes}" />
<c:set var="groupTypeAttributes" value="${DataDictionary.KimTypeBo.attributes}" />

<kul:tab tabTitle="Overview" defaultOpen="true" transparentBackground="${inquiry}" tabErrorKey="document.group*,document.active">
<div class="tab-container" align="center">
	<table cellpadding="0" cellspacing="0" summary=""> 
	 	<tr>
			<th><div align="right"><kul:htmlAttributeLabel attributeEntry="${groupAttributes.id}" labelFor="document.groupId" /></div></th>
	 		<td><kul:htmlControlAttribute property="document.groupId" attributeEntry="${groupAttributes.id}" readOnly="true" /></td>
    		<th><div align="right"><kul:htmlAttributeLabel attributeEntry="${groupTypeAttributes.name}" labelFor="document.groupTypeName" /></div></th>
	 		<td>
	 		    <kul:htmlControlAttribute property="document.groupTypeName" attributeEntry="${groupTypeAttributes.name}" readOnly="true" />
				<c:if test="${!readOnly}">
	            	<c:set var="bo" value="${KualiForm.kimTypeClass}"/>
	               	<kul:lookup boClassName="${bo}" 
	               	   fieldConversions=""  />
	           	</c:if>
	 		</td>
	 		<html:hidden property="document.groupTypeId" />
	 	</tr>
	 	<tr>
    		<th><div align="right"><kul:htmlAttributeLabel attributeEntry="${groupAttributes.namespaceCode}" labelFor="document.groupNamespace" /></div></th>
	 		<td>
	 		    <kul:htmlControlAttribute property="document.groupNamespace" attributeEntry="${groupAttributes.namespaceCode}" readOnly="${(readOnly || editingDocument)}" onchange="namespaceChanged( this.form );" />
	 		    <c:if test="${!inquiry && !readOnly && !editingDocument}">
	 		        <noscript>
	 		            <html:image tabindex="0" property="methodToCall.changeNamespace" src="${ConfigProperties.kr.externalizable.images.url}tinybutton-refresh.gif" styleClass="tinybutton" title="Click to refresh the page after changing the namespace." alt="Click to refresh the page after changing the namespace." />
	 		        </noscript>
	 		    </c:if>
	 		</td>
    		<th><div align="right"><kul:htmlAttributeLabel attributeEntry="${groupAttributes.name}" labelFor="document.groupName" /></div></th>
	 		<td><kul:htmlControlAttribute property="document.groupName" attributeEntry="${groupAttributes.name}" readOnly="${(readOnly || editingDocument)}" /></td>
	 	</tr>
	 	<tr>
			<th><div align="right"><kul:htmlAttributeLabel attributeEntry="${groupAttributes.active}" labelFor="document.active" /></div></th>
	 		<td><kul:htmlControlAttribute property="document.active" attributeEntry="${groupAttributes.active}" readOnly="${readOnly}" /></td>
	 		
			<th><div align="right"><kul:htmlAttributeLabel attributeEntry="${groupAttributes.description}" labelFor="document.groupDescription" /></div></th>
		    <td><kul:htmlControlAttribute property="document.groupDescription" attributeEntry="${groupAttributes.description}" readOnly="${readOnly}" /></td>
		    
	 	</tr>
	</table> 
</div>
</kul:tab>

