<%--
  #%L
  %%
  Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>
<%@ tag body-content="scriptless" %>
<%@ attribute name="byteSize" required="true" description="The size, in bytes, to display as a file size." %>

<%@ variable name-given="fileSize" scope="NESTED" %>
<%@ variable name-given="fileSizeUnits" scope="NESTED" %>

<c:if test="${byteSize lt 1024}" >
    <c:set var="fileSize" value="${byteSize}" />
    <c:set var="fileSizeUnits" value="bytes" />
</c:if>

<c:if test="${byteSize ge 1024}">
    <c:set var="kiloSize" value="${byteSize / 1024}" />

    <c:if test="${kiloSize lt 1024}" >
        <c:set var="fileSize" value="${kiloSize}" />
        <c:set var="fileSizeUnits" value="KB" />
    </c:if>

    <c:if test="${kiloSize ge 1024}">
        <c:set var="megaSize" value="${kiloSize / 1024}" />

        <c:if test="${megaSize lt 1024}" >
            <c:set var="fileSize" value="${megaSize}" />
            <c:set var="fileSizeUnits" value="MB" />
        </c:if>

        <c:if test="${megaSize ge 1024}">
            <c:set var="gigaSize" value="${megaSize / 1024}" />

            <c:set var="fileSize" value="${gigaSize}" />
            <c:set var="fileSizeUnits" value="GB" />
        </c:if>
    </c:if>
</c:if>

<c:set var="dot" value="." />
<c:if test="${fn:contains(fileSize, dot)}" >
    <c:set var="fileSize" value="${fn:substringBefore(fileSize, dot)}" />
</c:if>

<jsp:doBody/>
