/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.xml.spring;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.metainf.model.PathComparator;
import org.kuali.common.util.metainf.service.MetaInfUtils;
import org.kuali.common.util.metainf.spring.MetaInfDataType;
import org.kuali.common.util.project.model.ProjectIdentifier;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.kuali.rice.db.config.profile.MetaInfDataTypeProfileConfig;
import org.kuali.rice.db.config.profile.RiceMasterConfig;
import org.kuali.rice.db.config.profile.RiceServerBootstrapConfig;
import org.kuali.rice.db.config.profile.RiceServerDemoConfig;
import org.kuali.rice.xml.ingest.IngestXmlExecutable;
import org.kuali.rice.xml.project.XmlProjectConstants;
import org.kuali.rice.xml.spring.IngestXmlConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={IngestXmlConfig.class, RiceServerBootstrapConfig.class, RiceServerDemoConfig.class, RiceMasterConfig.class})
public class IngestXmlExecConfig {
    private static final String SKIP_KEY = "rice.ingest.skip";
    private static final String PATH_SEPARATOR = "/";
    private static final String UPGRADE_SQL_PATH = "upgrades/*";
    @Autowired
    EnvironmentService env;
    @Autowired
    MetaInfDataTypeProfileConfig typeConfig;

    @Bean
    public Executable ingestXmlExecutable() {
        ArrayList locations = Lists.newArrayList();
        List<MetaInfDataType> types = this.getTypes();
        PathComparator comparator = new PathComparator();
        for (MetaInfDataType type : types) {
            List resources = MetaInfUtils.getPatternedClasspathResources((ProjectIdentifier)XmlProjectConstants.ID, (Optional)Optional.of((Object)UPGRADE_SQL_PATH), (Optional)Optional.absent(), (Optional)Optional.of((Object)type), (String)"ingest");
            Collections.sort(resources, comparator);
            locations.addAll(resources);
        }
        Boolean skip = this.env.getBoolean(SKIP_KEY, Boolean.FALSE);
        return IngestXmlExecutable.builder(locations).skip(skip).build();
    }

    protected List<MetaInfDataType> getTypes() {
        return this.typeConfig != null ? this.typeConfig.getMetaInfDataTypes() : Lists.newArrayList();
    }
}

