/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.synonym;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import com.datical.liquibase.ext.appdba.synonym.change.DropSynonymChange;
import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.license.LicenseCheckingChangeGenerator;
import liquibase.change.Change;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.UnexpectedObjectChangeGenerator;
import liquibase.license.LicenseServiceUtils;
import liquibase.structure.DatabaseObject;

public class UnexpectedSynonymChangeGenerator
extends LicenseCheckingChangeGenerator
implements UnexpectedObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (Synonym.class.isAssignableFrom(clazz)) {
            if (!LicenseServiceUtils.checkForValidLicense("Liquibase Pro")) {
                return -1;
            }
            return 1;
        }
        return -1;
    }

    @Override
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return null;
    }

    @Override
    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return null;
    }

    @Override
    public Change[] fixUnexpected(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database object, Database database, ChangeGeneratorChain changeGeneratorChain) {
        if (!((Synonym)(databaseObject = (Synonym)databaseObject)).isPrivate() && !LiquibaseConfiguration.getInstance().getConfiguration(LiquibaseProConfiguration.class).getDropPublicSynonyms()) {
            return null;
        }
        object = new DropSynonymChange();
        ((DropSynonymChange)object).setSynonymName(((Synonym)databaseObject).getName());
        if (!(database instanceof MSSQLDatabase)) {
            ((DropSynonymChange)object).setPrivate(((Synonym)databaseObject).isPrivate());
        }
        ((DropSynonymChange)object).setObjectType(((Synonym)databaseObject).getObjectType());
        if (diffOutputControl.getIncludeCatalog()) {
            ((DropSynonymChange)object).setSynonymCatalogName(((Synonym)databaseObject).getSchema().getCatalogName());
        }
        if (diffOutputControl.getIncludeSchema()) {
            ((DropSynonymChange)object).setSynonymSchemaName(((Synonym)databaseObject).getSchema().getName());
        }
        return new Change[]{object};
    }
}

