/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.storedlogic.trigger.MissingTriggerChangeGenerator;
import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.CreateTriggerChange;
import com.datical.liquibase.ext.util.ObjectSqlFileUtil;
import liquibase.change.Change;
import liquibase.change.core.CreateProcedureChange;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.license.LicenseServiceUtils;
import liquibase.servicelocator.LiquibaseService;
import liquibase.structure.DatabaseObject;

@LiquibaseService
public class MissingTriggerExternalFileChangeGenerator
extends MissingTriggerChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (!LiquibaseConfiguration.getInstance().getConfiguration(LiquibaseProConfiguration.class).getInlineSql() && Trigger.class.isAssignableFrom(clazz)) {
            if (!LicenseServiceUtils.checkForValidLicense("Liquibase Pro")) {
                return -1;
            }
            return super.getPriority(clazz, database) + 100;
        }
        return -1;
    }

    @Override
    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl changeArray, Database object, Database database, ChangeGeneratorChain changeGeneratorChain) {
        changeArray = super.fixMissing(databaseObject, (DiffOutputControl)changeArray, (Database)object, database, changeGeneratorChain);
        object = MissingTriggerExternalFileChangeGenerator.findChange(CreateTriggerChange.class, changeArray);
        ((CreateProcedureChange)object).setRelativeToChangelogFile(Boolean.TRUE);
        ((CreateProcedureChange)object).setPath(ObjectSqlFileUtil.writeObjectSql((Trigger)databaseObject));
        ((CreateTriggerChange)object).setTriggerBody(null);
        return changeArray;
    }
}

