/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.packaged;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import liquibase.pro.packaged.ck;
import liquibase.pro.packaged.jJ;

public final class jI {
    public static List<Class<?>> findSuperTypes(Class<?> clazz, Class<?> clazz2) {
        return jI.findSuperTypes(clazz, clazz2, new ArrayList(8));
    }

    public static List<Class<?>> findSuperTypes(Class<?> clazz, Class<?> clazz2, List<Class<?>> list) {
        jI._addSuperTypes(clazz, clazz2, list, false);
        return list;
    }

    private static void _addSuperTypes(Class<?> clazz, Class<?> clazz2, Collection<Class<?>> collection, boolean bl2) {
        while (clazz != clazz2 && clazz != null && clazz != Object.class) {
            if (bl2) {
                if (collection.contains(clazz)) {
                    return;
                }
                collection.add(clazz);
            }
            Class<?>[] classArray = clazz.getInterfaces();
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                jI._addSuperTypes(classArray[i2], clazz2, collection, true);
            }
            bl2 = true;
            clazz = clazz.getSuperclass();
        }
        return;
    }

    public static String canBeABeanType(Class<?> clazz) {
        if (clazz.isAnnotation()) {
            return "annotation";
        }
        if (clazz.isArray()) {
            return "array";
        }
        if (clazz.isEnum()) {
            return "enum";
        }
        if (clazz.isPrimitive()) {
            return "primitive";
        }
        return null;
    }

    public static String isLocalType(Class<?> clazz, boolean bl2) {
        try {
            if (clazz.getEnclosingMethod() != null) {
                return "local/anonymous";
            }
            if (!bl2 && clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers())) {
                return "non-static member class";
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NullPointerException nullPointerException) {}
        return null;
    }

    public static Class<?> getOuterClass(Class<?> clazz) {
        try {
            if (clazz.getEnclosingMethod() != null) {
                return null;
            }
            if (!Modifier.isStatic(clazz.getModifiers())) {
                return clazz.getEnclosingClass();
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NullPointerException nullPointerException) {}
        return null;
    }

    public static boolean isProxyType(Class<?> object) {
        return ((String)(object = ((Class)object).getName())).startsWith("net.sf.cglib.proxy.") || ((String)object).startsWith("org.hibernate.proxy.");
    }

    public static boolean isConcrete(Class<?> clazz) {
        return (clazz.getModifiers() & 0x600) == 0;
    }

    public static boolean isConcrete(Member member) {
        return (member.getModifiers() & 0x600) == 0;
    }

    public static boolean isCollectionMapOrArray(Class<?> clazz) {
        if (clazz.isArray()) {
            return true;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Map.class.isAssignableFrom(clazz);
    }

    public static String getClassDescription(Object object) {
        if (object == null) {
            return "unknown";
        }
        return (object instanceof Class ? (Class<?>)object : object.getClass()).getName();
    }

    public static Class<?> findClass(String string) {
        if (string.indexOf(46) < 0) {
            if ("int".equals(string)) {
                return Integer.TYPE;
            }
            if ("long".equals(string)) {
                return Long.TYPE;
            }
            if ("float".equals(string)) {
                return Float.TYPE;
            }
            if ("double".equals(string)) {
                return Double.TYPE;
            }
            if ("boolean".equals(string)) {
                return Boolean.TYPE;
            }
            if ("byte".equals(string)) {
                return Byte.TYPE;
            }
            if ("char".equals(string)) {
                return Character.TYPE;
            }
            if ("short".equals(string)) {
                return Short.TYPE;
            }
            if ("void".equals(string)) {
                return Void.TYPE;
            }
        }
        Throwable throwable = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                return Class.forName(string, true, classLoader);
            }
            catch (Exception exception) {
                throwable = jI.getRootCause(exception);
            }
        }
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            if (throwable == null) {
                throwable = jI.getRootCause(exception);
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new ClassNotFoundException(throwable.getMessage(), throwable);
        }
    }

    public static boolean hasGetterSignature(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray != null && classArray.length != 0) {
            return false;
        }
        return Void.TYPE != method.getReturnType();
    }

    public static Throwable getRootCause(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static void throwRootCause(Throwable throwable) {
        if ((throwable = jI.getRootCause(throwable)) instanceof Exception) {
            throw (Exception)throwable;
        }
        throw (Error)throwable;
    }

    public static void throwAsIAE(Throwable throwable) {
        Throwable throwable2 = throwable;
        jI.throwAsIAE(throwable2, throwable2.getMessage());
    }

    public static void throwAsIAE(Throwable throwable, String string) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new IllegalArgumentException(string, throwable);
    }

    public static void unwrapAndThrowAsIAE(Throwable throwable) {
        jI.throwAsIAE(jI.getRootCause(throwable));
    }

    public static void unwrapAndThrowAsIAE(Throwable throwable, String string) {
        jI.throwAsIAE(jI.getRootCause(throwable), string);
    }

    public static <T> T createInstance(Class<T> clazz, boolean bl2) {
        Constructor<T> constructor = jI.findConstructor(clazz, bl2);
        if (constructor == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " has no default (no arg) constructor");
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            constructor = exception;
            jI.unwrapAndThrowAsIAE(exception, "Failed to instantiate class " + clazz.getName() + ", problem: " + ((Throwable)((Object)constructor)).getMessage());
            return null;
        }
    }

    public static <T> Constructor<T> findConstructor(Class<T> clazz, boolean bl2) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (bl2) {
                jI.checkAndFixAccess(constructor);
            } else if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new IllegalArgumentException("Default constructor for " + clazz.getName() + " is not accessible (non-public?): not allowed to try modify access via Reflection: can not instantiate type");
            }
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            jI.unwrapAndThrowAsIAE(exception, "Failed to find default constructor of class " + clazz.getName() + ", problem: " + exception2.getMessage());
        }
        return null;
    }

    public static Object defaultValue(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        throw new IllegalArgumentException("Class " + clazz.getName() + " is not a primitive type");
    }

    public static Class<?> wrapperType(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        throw new IllegalArgumentException("Class " + clazz.getName() + " is not a primitive type");
    }

    public static void checkAndFixAccess(Member member) {
        AnnotatedElement annotatedElement = (AccessibleObject)((Object)member);
        try {
            ((AccessibleObject)annotatedElement).setAccessible(true);
            return;
        }
        catch (SecurityException securityException) {
            if (!((AccessibleObject)annotatedElement).isAccessible()) {
                annotatedElement = member.getDeclaringClass();
                throw new IllegalArgumentException("Can not access " + member + " (from class " + ((Class)annotatedElement).getName() + "; failed to set access: " + securityException.getMessage());
            }
            return;
        }
    }

    public static Class<? extends Enum<?>> findEnumType(EnumSet<?> enumSet) {
        if (!enumSet.isEmpty()) {
            return jI.findEnumType((Enum)enumSet.iterator().next());
        }
        return jJ.instance.enumTypeFor(enumSet);
    }

    public static Class<? extends Enum<?>> findEnumType(EnumMap<?, ?> enumMap) {
        if (!enumMap.isEmpty()) {
            return jI.findEnumType((Enum)enumMap.keySet().iterator().next());
        }
        return jJ.instance.enumTypeFor(enumMap);
    }

    public static Class<? extends Enum<?>> findEnumType(Enum<?> clazz) {
        if ((clazz = clazz.getClass()).getSuperclass() != Enum.class) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static Class<? extends Enum<?>> findEnumType(Class<?> clazz) {
        if (clazz.getSuperclass() != Enum.class) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static boolean isJacksonStdImpl(Object object) {
        return object != null && jI.isJacksonStdImpl(object.getClass());
    }

    public static boolean isJacksonStdImpl(Class<?> clazz) {
        return clazz.getAnnotation(ck.class) != null;
    }
}

