/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification;

import java.time.Duration;
import org.mockito.exceptions.base.MockitoAssertionError;
import org.mockito.internal.util.Timer;
import org.mockito.internal.verification.AtMost;
import org.mockito.internal.verification.NoMoreInteractions;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.verification.VerificationMode;

public class VerificationOverTimeImpl
implements VerificationMode {
    private final Duration pollingPeriod;
    private final VerificationMode delegate;
    private final boolean returnOnSuccess;
    private final Timer timer;

    public VerificationOverTimeImpl(Duration pollingPeriod, Duration duration, VerificationMode delegate, boolean returnOnSuccess) {
        this(pollingPeriod, delegate, returnOnSuccess, new Timer(duration));
    }

    public VerificationOverTimeImpl(Duration pollingPeriod, VerificationMode delegate, boolean returnOnSuccess, Timer timer) {
        this.pollingPeriod = pollingPeriod;
        this.delegate = delegate;
        this.returnOnSuccess = returnOnSuccess;
        this.timer = timer;
    }

    @Override
    public void verify(VerificationData data) {
        AssertionError error = null;
        this.timer.start();
        while (this.timer.isCounting()) {
            try {
                this.delegate.verify(data);
                if (this.returnOnSuccess) {
                    return;
                }
                error = null;
            }
            catch (MockitoAssertionError e) {
                error = this.handleVerifyException(e);
            }
            catch (AssertionError e) {
                error = this.handleVerifyException(e);
            }
        }
        if (error != null) {
            throw error;
        }
    }

    private AssertionError handleVerifyException(AssertionError e) {
        if (this.canRecoverFromFailure(this.delegate)) {
            this.sleep(this.pollingPeriod);
            return e;
        }
        throw e;
    }

    protected boolean canRecoverFromFailure(VerificationMode verificationMode) {
        return !(verificationMode instanceof AtMost) && !(verificationMode instanceof NoMoreInteractions);
    }

    public VerificationOverTimeImpl copyWithVerificationMode(VerificationMode verificationMode) {
        return new VerificationOverTimeImpl(this.pollingPeriod, this.timer.duration(), verificationMode, this.returnOnSuccess);
    }

    private void sleep(Duration sleep) {
        try {
            Thread.sleep(sleep.toMillis());
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Thread sleep has been interrupted", ie);
        }
    }

    public boolean isReturnOnSuccess() {
        return this.returnOnSuccess;
    }

    public Duration getPollingPeriod() {
        return this.pollingPeriod;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public VerificationMode getDelegate() {
        return this.delegate;
    }
}

