/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.defaultanswers;

import java.io.Serializable;
import java.time.Duration;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.ObjectMethodsGuru;
import org.mockito.internal.util.Primitives;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.mock.MockName;
import org.mockito.stubbing.Answer;

public class ReturnsEmptyValues
implements Answer<Object>,
Serializable {
    private static final long serialVersionUID = 1998191268711234347L;

    @Override
    public Object answer(InvocationOnMock invocation) {
        if (ObjectMethodsGuru.isToStringMethod(invocation.getMethod())) {
            Object mock = invocation.getMock();
            MockName name = MockUtil.getMockName(mock);
            if (name.isDefault()) {
                return "Mock for " + MockUtil.getMockSettings(mock).getTypeToMock().getSimpleName() + ", hashCode: " + mock.hashCode();
            }
            return name.toString();
        }
        if (ObjectMethodsGuru.isCompareToMethod(invocation.getMethod())) {
            return invocation.getMock() == invocation.getArgument(0) ? 0 : 1;
        }
        Class<?> returnType = invocation.getMethod().getReturnType();
        return this.returnValueFor(returnType);
    }

    Object returnValueFor(Class<?> type) {
        Object sequencedCollection = this.returnValueForSequencedCollection(type);
        if (sequencedCollection != null) {
            return sequencedCollection;
        }
        if (Primitives.isPrimitiveOrWrapper(type)) {
            return Primitives.defaultValue(type);
        }
        if (type == Iterable.class) {
            return new ArrayList(0);
        }
        if (type == Collection.class) {
            return new LinkedList();
        }
        if (type == Set.class) {
            return new HashSet();
        }
        if (type == HashSet.class) {
            return new HashSet();
        }
        if (type == SortedSet.class) {
            return new TreeSet();
        }
        if (type == TreeSet.class) {
            return new TreeSet();
        }
        if (type == LinkedHashSet.class) {
            return new LinkedHashSet();
        }
        if (type == List.class) {
            return new LinkedList();
        }
        if (type == LinkedList.class) {
            return new LinkedList();
        }
        if (type == ArrayList.class) {
            return new ArrayList();
        }
        if (type == Map.class) {
            return new HashMap();
        }
        if (type == HashMap.class) {
            return new HashMap();
        }
        if (type == SortedMap.class) {
            return new TreeMap();
        }
        if (type == TreeMap.class) {
            return new TreeMap();
        }
        if (type == LinkedHashMap.class) {
            return new LinkedHashMap();
        }
        if (type == Stream.class) {
            return Stream.empty();
        }
        if (type == DoubleStream.class) {
            return DoubleStream.empty();
        }
        if (type == IntStream.class) {
            return IntStream.empty();
        }
        if (type == LongStream.class) {
            return LongStream.empty();
        }
        if (type == Duration.class) {
            return Duration.ZERO;
        }
        if (type == Period.class) {
            return Period.ZERO;
        }
        if (type == CompletableFuture.class || type == CompletionStage.class || type == Future.class) {
            return CompletableFuture.completedFuture(null);
        }
        return ReturnsEmptyValues.returnCommonEmptyValueFor(type);
    }

    private Object returnValueForSequencedCollection(Class<?> type) {
        String typeName = type.getName();
        if (Objects.equals("java.util.SequencedCollection", typeName)) {
            return new ArrayList();
        }
        if (Objects.equals("java.util.SequencedSet", typeName)) {
            return new LinkedHashSet();
        }
        if (Objects.equals("java.util.SequencedMap", typeName)) {
            return new LinkedHashMap();
        }
        return null;
    }

    static Object returnCommonEmptyValueFor(Class<?> type) {
        if (type == Optional.class) {
            return Optional.empty();
        }
        if (type == OptionalDouble.class) {
            return OptionalDouble.empty();
        }
        if (type == OptionalInt.class) {
            return OptionalInt.empty();
        }
        if (type == OptionalLong.class) {
            return OptionalLong.empty();
        }
        return null;
    }
}

