/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoCursorNotFoundException;
import com.mongodb.MongoNamespace;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.ByteBufBsonDocument;
import com.mongodb.connection.ByteBufferBsonOutput;
import com.mongodb.connection.GetMoreMessage;
import com.mongodb.connection.GetMoreResultCallback;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.Protocol;
import com.mongodb.connection.ProtocolHelper;
import com.mongodb.connection.QueryResult;
import com.mongodb.connection.ReplyMessage;
import com.mongodb.connection.ResponseBuffers;
import com.mongodb.connection.SendMessageCallback;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.event.CommandListener;
import java.util.Collections;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;
import org.bson.io.BsonOutput;

class GetMoreProtocol<T>
implements Protocol<QueryResult<T>> {
    public static final Logger LOGGER = Loggers.getLogger("protocol.getmore");
    private static final String COMMAND_NAME = "getMore";
    private final Decoder<T> resultDecoder;
    private final MongoNamespace namespace;
    private final long cursorId;
    private final int numberToReturn;
    private CommandListener commandListener;

    public GetMoreProtocol(MongoNamespace namespace, long cursorId, int numberToReturn, Decoder<T> resultDecoder) {
        this.namespace = namespace;
        this.cursorId = cursorId;
        this.numberToReturn = numberToReturn;
        this.resultDecoder = resultDecoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResult<T> execute(InternalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Getting more documents from namespace %s with cursor %d on connection [%s] to server %s", this.namespace, this.cursorId, connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
        }
        long startTimeNanos = System.nanoTime();
        GetMoreMessage message = new GetMoreMessage(this.namespace.getFullName(), this.cursorId, this.numberToReturn);
        QueryResult<T> queryResult = null;
        try {
            this.sendMessage(message, connection);
            ResponseBuffers responseBuffers = connection.receiveMessage(message.getId());
            try {
                if (responseBuffers.getReplyHeader().isCursorNotFound()) {
                    throw new MongoCursorNotFoundException(message.getCursorId(), connection.getDescription().getServerAddress());
                }
                if (responseBuffers.getReplyHeader().isQueryFailure()) {
                    BsonDocument errorDocument = (BsonDocument)new ReplyMessage(responseBuffers, new BsonDocumentCodec(), message.getId()).getDocuments().get(0);
                    throw ProtocolHelper.getQueryFailureException(errorDocument, connection.getDescription().getServerAddress());
                }
                queryResult = new QueryResult<T>(this.namespace, new ReplyMessage<T>(responseBuffers, this.resultDecoder, message.getId()), connection.getDescription().getServerAddress());
                if (this.commandListener != null) {
                    ProtocolHelper.sendCommandSucceededEvent(message, COMMAND_NAME, this.asGetMoreCommandResponseDocument(queryResult, responseBuffers), connection.getDescription(), startTimeNanos, this.commandListener);
                }
            }
            finally {
                responseBuffers.close();
            }
            LOGGER.debug("Get-more completed");
            return queryResult;
        }
        catch (RuntimeException e) {
            if (this.commandListener != null) {
                ProtocolHelper.sendCommandFailedEvent(message, COMMAND_NAME, connection.getDescription(), startTimeNanos, e, this.commandListener);
            }
            throw e;
        }
    }

    @Override
    public void executeAsync(InternalConnection connection, SingleResultCallback<QueryResult<T>> callback) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Asynchronously getting more documents from namespace %s with cursor %d on connection [%s] to server %s", this.namespace, this.cursorId, connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
            }
            ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
            GetMoreMessage message = new GetMoreMessage(this.namespace.getFullName(), this.cursorId, this.numberToReturn);
            ProtocolHelper.encodeMessage(message, (BsonOutput)bsonOutput);
            GetMoreResultCallback<T> receiveCallback = new GetMoreResultCallback<T>(this.namespace, callback, this.resultDecoder, this.cursorId, message.getId(), connection.getDescription().getServerAddress());
            connection.sendMessageAsync(bsonOutput.getByteBuffers(), message.getId(), new SendMessageCallback<QueryResult<T>>(connection, bsonOutput, message.getId(), callback, receiveCallback));
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    @Override
    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(GetMoreMessage message, InternalConnection connection) {
        ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
        try {
            if (this.commandListener != null) {
                ProtocolHelper.sendCommandStartedEvent(message, this.namespace.getDatabaseName(), COMMAND_NAME, this.asGetMoreCommandDocument(), connection.getDescription(), this.commandListener);
            }
            message.encode((BsonOutput)bsonOutput);
            connection.sendMessage(bsonOutput.getByteBuffers(), message.getId());
        }
        finally {
            bsonOutput.close();
        }
    }

    private BsonDocument asGetMoreCommandDocument() {
        return new BsonDocument(COMMAND_NAME, (BsonValue)new BsonInt64(this.cursorId)).append("collection", (BsonValue)new BsonString(this.namespace.getCollectionName())).append("batchSize", (BsonValue)new BsonInt32(this.numberToReturn));
    }

    private BsonDocument asGetMoreCommandResponseDocument(QueryResult<T> queryResult, ResponseBuffers responseBuffers) {
        List<Object> rawResultDocuments = Collections.emptyList();
        if (responseBuffers.getReplyHeader().getNumberReturned() != 0) {
            responseBuffers.getBodyByteBuffer().position(0);
            rawResultDocuments = ByteBufBsonDocument.create(responseBuffers);
        }
        BsonDocument cursorDocument = new BsonDocument("id", (BsonValue)(queryResult.getCursor() == null ? new BsonInt64(0L) : new BsonInt64(queryResult.getCursor().getId()))).append("ns", (BsonValue)new BsonString(this.namespace.getFullName())).append("nextBatch", (BsonValue)new BsonArray(rawResultDocuments));
        return new BsonDocument("cursor", (BsonValue)cursorDocument).append("ok", (BsonValue)new BsonDouble(1.0));
    }
}

