/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.model.api;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.model.ConnectorCategory;
import org.mule.connectivity.restconnect.internal.model.MavenDependency;
import org.mule.connectivity.restconnect.internal.model.api.RestConnectAPIModel;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.mule.connectivity.restconnect.internal.model.uri.BaseUri;

public class RestConnectModelBuilder {
    private String apiName;
    private String apiDescription;
    private String groupId;
    private String artifactId;
    private String version;
    private String customPackage;
    private ConnectorCategory category;
    private List<MavenDependency> dependencies = new ArrayList<MavenDependency>();
    private String projectDescription;
    private List<Operation> operations;
    private BaseUri baseUri;
    private Path rootDir;

    private RestConnectModelBuilder() {
    }

    public static RestConnectModelBuilder createModel() {
        return new RestConnectModelBuilder();
    }

    public RestConnectModelBuilder withApiName(String apiName) {
        if (StringUtils.isNotBlank((CharSequence)apiName)) {
            this.apiName = apiName;
        }
        return this;
    }

    public RestConnectModelBuilder withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public RestConnectModelBuilder withArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public RestConnectModelBuilder withVersion(String version) {
        this.version = version;
        return this;
    }

    public RestConnectModelBuilder withCategory(ConnectorCategory category) {
        this.category = category;
        return this;
    }

    public RestConnectModelBuilder withCustomPackage(String customPackage) {
        this.customPackage = customPackage;
        return this;
    }

    public RestConnectModelBuilder withCategory(String category) {
        this.category = ConnectorCategory.fromString(category);
        return this;
    }

    public RestConnectModelBuilder withDependency(MavenDependency dependency) {
        this.dependencies.add(dependency);
        return this;
    }

    public RestConnectModelBuilder withProjectDescription(String description) {
        this.projectDescription = description;
        return this;
    }

    public RestConnectModelBuilder withApiDescription(String apiDescription) {
        this.apiDescription = apiDescription;
        return this;
    }

    public RestConnectModelBuilder withOperations(List<Operation> operations) {
        this.operations = operations;
        return this;
    }

    public RestConnectModelBuilder withBaseUri(BaseUri baseUri) {
        this.baseUri = baseUri;
        return this;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCustomPackage() {
        return this.customPackage;
    }

    public List<MavenDependency> getDependencies() {
        return this.dependencies;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public ConnectorCategory getCategory() {
        return this.category;
    }

    public BaseUri getBaseUri() {
        return this.baseUri;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public String getApiDescription() {
        return this.apiDescription;
    }

    public RestConnectAPIModel build() {
        return new RestConnectAPIModel(this);
    }

    public RestConnectModelBuilder withRootDir(Path rootDir) {
        this.rootDir = rootDir;
        return this;
    }

    public Path getRootDir() {
        return this.rootDir;
    }
}

