/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.model.operation;

import java.util.LinkedList;
import java.util.List;
import org.mule.connectivity.restconnect.internal.model.HTTPMethod;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.PartParameter;
import org.mule.connectivity.restconnect.internal.model.security.APISecurityScheme;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.model.typesource.MultipartTypeSource;

public class Operation {
    private String friendlyName;
    private String annotatedDisplayName;
    private String description;
    private String canonicalName;
    private List<Parameter> uriParameters = new LinkedList<Parameter>();
    private List<Parameter> queryParameters = new LinkedList<Parameter>();
    private List<Parameter> headers = new LinkedList<Parameter>();
    private List<Parameter> parameters = new LinkedList<Parameter>();
    private TypeDefinition inputMetadata;
    private TypeDefinition outputMetadata;
    private HTTPMethod httpMethod;
    private String uri;
    private List<APISecurityScheme> securitySchemes;
    private boolean userSelectedSecuritySchemes;

    Operation() {
    }

    public List<Parameter> getQueryParameters() {
        return this.queryParameters;
    }

    public List<Parameter> getUriParameters() {
        return this.uriParameters;
    }

    public List<Parameter> getHeaders() {
        return this.headers;
    }

    public List<Parameter> getPartParameters() {
        LinkedList<Parameter> partParameters = new LinkedList<Parameter>();
        if (this.inputMetadata != null && this.inputMetadata.getSource() instanceof MultipartTypeSource) {
            for (PartParameter part : ((MultipartTypeSource)this.inputMetadata.getSource()).getParts()) {
                if (part.getPartNameParameter() != null) {
                    partParameters.add(part.getPartNameParameter());
                }
                if (part.getPartFilenameParameter() == null) continue;
                partParameters.add(part.getPartFilenameParameter());
            }
        }
        return partParameters;
    }

    public String getHttpMethod() {
        return this.httpMethod.toString().toLowerCase();
    }

    public String getUri() {
        return this.uri;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public TypeDefinition getInputMetadata() {
        return this.inputMetadata;
    }

    public TypeDefinition getOutputMetadata() {
        return this.outputMetadata;
    }

    public String getAnnotatedDisplayName() {
        return this.annotatedDisplayName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public void setAnnotatedDisplayName(String annotatedDisplayName) {
        this.annotatedDisplayName = annotatedDisplayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setHttpMethod(HTTPMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setUriParameters(List<Parameter> uriParams) {
        this.uriParameters = uriParams;
    }

    public void setQueryParameters(List<Parameter> queryParams) {
        this.queryParameters = queryParams;
    }

    public void setHeaders(List<Parameter> headers) {
        this.headers = headers;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void setInputMetadata(TypeDefinition inputMetadata) {
        this.inputMetadata = inputMetadata;
    }

    public void setOutputMetadata(TypeDefinition outputMetadata) {
        this.outputMetadata = outputMetadata;
    }

    public List<APISecurityScheme> getSecuritySchemes() {
        return this.securitySchemes;
    }

    public void setSecuritySchemes(List<APISecurityScheme> securitySchemes) {
        this.securitySchemes = securitySchemes;
    }

    public boolean isUserSelectedSecuritySchemes() {
        return this.userSelectedSecuritySchemes;
    }

    public void setUserSelectedSecuritySchemes(boolean userSelectedSecuritySchemes) {
        this.userSelectedSecuritySchemes = userSelectedSecuritySchemes;
    }
}

