/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.model.parameter;

import org.apache.commons.lang.StringUtils;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;

public class Parameter {
    private String internalPrefix;
    private String externalName;
    private TypeDefinition typeDefinition;
    private String fixedValue;
    private boolean isPassword;
    private boolean generated;
    private ParameterType parameterType;
    private boolean duplicatedName;

    public Parameter(String externalName, ParameterType parameterType, TypeDefinition typeDefinition) {
        this.externalName = externalName;
        this.typeDefinition = typeDefinition;
        this.parameterType = parameterType;
    }

    public Parameter(String externalName, ParameterType parameterType, TypeDefinition typeDefinition, boolean password, boolean generated) {
        this.externalName = externalName;
        this.typeDefinition = typeDefinition;
        this.isPassword = password;
        this.generated = generated;
        this.parameterType = parameterType;
    }

    public Parameter(String externalName, ParameterType parameterType, String internalPrefix, TypeDefinition typeDefinition, boolean password) {
        this.externalName = externalName;
        this.typeDefinition = typeDefinition;
        this.isPassword = password;
        this.parameterType = parameterType;
        this.internalPrefix = internalPrefix;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public void setExternalName(String name) {
        this.externalName = name;
    }

    public String getInternalName() {
        String internalName = this.externalName;
        if (this.duplicatedName) {
            internalName = this.parameterType.getName() + this.externalName;
        }
        if (StringUtils.isNotBlank((String)this.internalPrefix)) {
            internalName = this.internalPrefix + internalName;
        }
        return internalName;
    }

    public TypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public String getFixedValue() {
        return this.fixedValue;
    }

    public void setFixedValue(String fixedValue) {
        this.fixedValue = fixedValue;
    }

    public boolean hasFixedValue() {
        return !StringUtils.isBlank((String)this.fixedValue);
    }

    public boolean isPassword() {
        return this.isPassword;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public void setPassword(boolean password) {
        this.isPassword = password;
    }

    public boolean isDuplicatedName() {
        return this.duplicatedName;
    }

    public void setDuplicatedName(boolean duplicatedExternalName) {
        this.duplicatedName = duplicatedExternalName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Parameter)) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        if (this.isPassword != parameter.isPassword) {
            return false;
        }
        if (this.duplicatedName != parameter.duplicatedName) {
            return false;
        }
        if (this.internalPrefix != null ? !this.internalPrefix.equals(parameter.internalPrefix) : parameter.internalPrefix != null) {
            return false;
        }
        if (this.externalName != null ? !this.externalName.equals(parameter.externalName) : parameter.externalName != null) {
            return false;
        }
        if (this.typeDefinition != null ? !this.typeDefinition.equals(parameter.typeDefinition) : parameter.typeDefinition != null) {
            return false;
        }
        if (this.fixedValue != null ? !this.fixedValue.equals(parameter.fixedValue) : parameter.fixedValue != null) {
            return false;
        }
        return this.parameterType == parameter.parameterType;
    }

    public int hashCode() {
        int result = this.internalPrefix != null ? this.internalPrefix.hashCode() : 0;
        result = 31 * result + (this.externalName != null ? this.externalName.hashCode() : 0);
        result = 31 * result + (this.typeDefinition != null ? this.typeDefinition.hashCode() : 0);
        result = 31 * result + (this.fixedValue != null ? this.fixedValue.hashCode() : 0);
        result = 31 * result + (this.isPassword ? 1 : 0);
        result = 31 * result + (this.parameterType != null ? this.parameterType.hashCode() : 0);
        result = 31 * result + (this.duplicatedName ? 1 : 0);
        return result;
    }
}

