/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.model.security;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.MediaType;
import org.mule.connectivity.restconnect.internal.model.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.model.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinitionBuilder;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;

public abstract class APISecurityScheme {
    public static final String BASIC = "Basic Authentication";
    public static final String OAUTH1 = "OAuth 1.0";
    public static final String OAUTH2 = "OAuth 2.0";
    public static final String PASS_THROUGH = "Pass Through";
    public static final String DIGEST_AUTHENTICATION = "Digest Authentication";
    public static final String CUSTOM_AUTHENTICATION = "Custom Authentication";
    public static final String JWT = "Jwt";
    public static final String CUSTOM_JWT = "x-Jwt";
    public static final String UNSECURED = "";
    protected List<Parameter> configParameters = new LinkedList<Parameter>();
    protected List<Parameter> headers = new LinkedList<Parameter>();
    protected List<Parameter> queryParameters = new LinkedList<Parameter>();

    public APISecurityScheme() {
        this.initializeConfigParameters();
    }

    public abstract String getSchemeName();

    public abstract void initializeConfigParameters();

    public List<Parameter> getConfigParameters() {
        return this.configParameters;
    }

    public List<Parameter> getQueryParameters() {
        return this.queryParameters;
    }

    public List<Parameter> getHeaders() {
        return this.headers;
    }

    public boolean hasQueryParameters() {
        return !this.queryParameters.isEmpty();
    }

    public boolean hasHeaders() {
        return !this.headers.isEmpty();
    }

    public boolean hasConfigParameters() {
        return !this.configParameters.isEmpty();
    }

    public boolean equals(APISecurityScheme scheme) {
        return scheme.getClass().equals(this.getClass()) && scheme.getSchemeName().equals(this.getSchemeName()) && this.equalProperties(scheme);
    }

    protected abstract boolean equalProperties(APISecurityScheme var1);

    public static Parameter getSecuritySchemeParameter(String name, String displayName, PrimitiveTypeSource.PrimitiveType type, String description, String defaultValue, String example, boolean required, boolean isPassword, String ... enumValues) {
        return APISecurityScheme.getSecuritySchemeParameter(name, displayName, type, description, defaultValue, example, required, isPassword, false, enumValues);
    }

    public static Parameter getSecuritySchemeParameter(String name, String displayName, PrimitiveTypeSource.PrimitiveType type, String description, String defaultValue, String example, boolean required, boolean isPassword, boolean generated, String ... enumValues) {
        return new Parameter(name, ParameterType.SECURITY, new TypeDefinitionBuilder(MediaType.TEXT_PLAIN_TYPE, new PrimitiveTypeSource(type), required, false, false).withAnnotatedDisplayName(Optional.ofNullable(displayName).orElse(name)).withDescription(description).withDefaultValue(defaultValue).withExample(example).withEnumValues(Optional.ofNullable(enumValues).filter(Predicate.isEqual(new String[0]).negate()).map(Stream::of).map(stream -> stream.collect(Collectors.toList())).orElse(null)).build(), isPassword, generated);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof APISecurityScheme)) {
            return false;
        }
        APISecurityScheme that = (APISecurityScheme)o;
        if (this.configParameters != null ? !this.configParameters.equals(that.configParameters) : that.configParameters != null) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) {
            return false;
        }
        return this.queryParameters != null ? this.queryParameters.equals(that.queryParameters) : that.queryParameters == null;
    }

    public int hashCode() {
        int result = this.configParameters != null ? this.configParameters.hashCode() : 0;
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        result = 31 * result + (this.queryParameters != null ? this.queryParameters.hashCode() : 0);
        return result;
    }
}

