/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.model.typesource;

import java.io.IOException;
import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.internal.model.typesource.TypeSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlTypeSource
implements TypeSource {
    private String value;
    private String elementName;
    private String schemaPath;
    private static final String EXTERNAL_GENERAL_ENTITIES_FEATURE = "http://xml.org/sax/features/external-general-entities";
    private static final String EXTERNAL_PARAMETER_ENTITIES_FEATURE = "http://xml.org/sax/features/external-parameter-entities";
    private static final String LOAD_EXTERNAL_DTD_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static DocumentBuilderFactory dbf = null;

    public XmlTypeSource(String schemaContent) {
        this.value = schemaContent;
        this.elementName = null;
        this.schemaPath = null;
    }

    public XmlTypeSource(String schemaContent, String elementName, String schemaPath) {
        this.value = schemaContent;
        this.elementName = elementName;
        this.schemaPath = schemaPath;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String getSchemaPath() {
        return this.schemaPath;
    }

    public String getElementName() throws GenerationException {
        if (this.elementName == null) {
            this.elementName = this.getDefaultElementName();
        }
        return this.elementName;
    }

    private String getDefaultElementName() throws GenerationException {
        try {
            InputSource inputSource = new InputSource(new StringReader(this.value));
            Document doc = null;
            doc = this.parseDoPriv(inputSource, XmlTypeSource.getSecureDocumentBuilder(), doc);
            XmlSchemaCollection schemaCol = new XmlSchemaCollection();
            XmlSchema schema = schemaCol.read(doc, inputSource.getSystemId(), null);
            return schema.getElements().keySet().isEmpty() ? null : schema.getElements().keySet().toArray()[0].toString();
        }
        catch (IOException | SAXException e) {
            throw new GenerationException("Could not parse XML element.\n " + this.value);
        }
    }

    private Document parseDoPriv(InputSource inputSource, DocumentBuilder builder, Document doc) throws IOException, SAXException {
        block3: {
            try {
                doc = AccessController.doPrivileged(() -> builder.parse(inputSource));
            }
            catch (PrivilegedActionException e) {
                Exception exception = e.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof SAXException)) break block3;
                throw (SAXException)exception;
            }
        }
        return doc;
    }

    private static DocumentBuilder getSecureDocumentBuilder() throws GenerationException {
        try {
            if (dbf == null) {
                dbf = DocumentBuilderFactory.newInstance();
                dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
                dbf.setFeature(EXTERNAL_GENERAL_ENTITIES_FEATURE, false);
                dbf.setFeature(EXTERNAL_PARAMETER_ENTITIES_FEATURE, false);
                dbf.setFeature(LOAD_EXTERNAL_DTD_FEATURE, false);
                dbf.setXIncludeAware(false);
                dbf.setExpandEntityReferences(false);
                dbf.setNamespaceAware(true);
            }
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new GenerationException("Could not configure document builder", e);
        }
    }
}

