/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.ramlParser.resourceLoader;

import com.google.common.base.Strings;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import javax.annotation.Nullable;
import org.raml.v2.api.loader.ClassPathResourceLoader;
import org.raml.v2.api.loader.CompositeResourceLoader;
import org.raml.v2.api.loader.FileResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeFileResourceLoader
implements ResourceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeFileResourceLoader.class);
    private final Path rootDir;
    private final ResourceLoader resourceLoader = new CompositeResourceLoader(new ResourceLoader[]{new ClassPathResourceLoader(), new FileResourceLoader(".")});

    public SafeFileResourceLoader(String rootDir) {
        String basePath = rootDir != null ? rootDir : ".";
        basePath = basePath.startsWith("file://") ? basePath.substring(7) : basePath;
        this.rootDir = new File(basePath.replace("%20", " ")).toPath();
    }

    @Nullable
    public InputStream fetchResource(String resourceName) {
        if (this.accepts(resourceName)) {
            return this.resourceLoader.fetchResource(resourceName);
        }
        return null;
    }

    private boolean accepts(String resource) {
        if (Strings.isNullOrEmpty((String)resource)) {
            return false;
        }
        try {
            String src = resource.startsWith("file://") ? resource.substring(7) : resource;
            src = src.replace("%20", " ");
            Path path = new File(src).getCanonicalFile().toPath();
            return path.startsWith(this.rootDir);
        }
        catch (Exception e) {
            LOGGER.warn("Error evaluating resource", (Throwable)e);
            return false;
        }
    }
}

