/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.modelGeneration.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.mule.connectivity.restconnect.internal.model.operation.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationMappingUtils {
    protected static final Logger logger = LoggerFactory.getLogger(OperationMappingUtils.class);

    protected OperationMappingUtils() {
    }

    public static void disambiguateRepeatedOperations(List<? extends Operation> operations) {
        HashSet<String> repeatedNames = new HashSet<String>();
        HashMap<String, Integer> replacedNames = new HashMap<String, Integer>();
        for (Operation operation : operations) {
            String name = operation.getCanonicalName();
            if (replacedNames.containsKey(name)) {
                repeatedNames.add(name);
                continue;
            }
            replacedNames.put(name, 0);
        }
        for (Operation operation : operations) {
            String operationName = operation.getCanonicalName();
            if (!repeatedNames.contains(operationName)) continue;
            int occurrences = (Integer)replacedNames.get(operationName) + 1;
            operation.setCanonicalName(String.format("%s_%d", operationName, occurrences));
            replacedNames.put(operationName, occurrences);
        }
    }
}

