/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.model.MavenDependency;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorSecuritySchemeDecorator;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorSecuritySchemeDecoratorHelper;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorXMLConfig;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorXMLSchema;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.security.smartconnector.SmartConnectorXMLSchemaLocation;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.type.SmartConnectorTypeDefinitionDecorator;

public class SmartConnectorMergedSchemeDecorator {
    private final List<SmartConnectorSecuritySchemeDecorator> securitySchemes;
    private final List<SmartConnectorXMLConfig> xmlConfigs;
    private final List<SmartConnectorXMLSchema> xmlSchemas;
    private final List<SmartConnectorXMLSchemaLocation> xmlSchemaLocations;
    private final List<MavenDependency> pomDependencies;
    private final String modulePrefix;

    public SmartConnectorMergedSchemeDecorator(List<SmartConnectorSecuritySchemeDecorator> securitySchemes, String modulePrefix) {
        this.securitySchemes = securitySchemes;
        this.xmlConfigs = this.buildXmlConfigs();
        this.xmlSchemas = this.buildXmlSchemas();
        this.xmlSchemaLocations = this.buildXmlSchemaLocations();
        this.pomDependencies = this.buildPomDependencies();
        this.modulePrefix = modulePrefix;
    }

    private List<MavenDependency> buildPomDependencies() {
        LinkedList<MavenDependency> dependencies = new LinkedList<MavenDependency>();
        for (SmartConnectorSecuritySchemeDecorator scheme : this.securitySchemes) {
            for (MavenDependency dependency : scheme.getPomDependencies()) {
                if (!dependencies.stream().noneMatch(x -> x.getArtifactId().equals(dependency.getGroupId()) && x.getGroupId().equals(dependency.getGroupId()))) continue;
                dependencies.add(dependency);
            }
        }
        return dependencies;
    }

    protected List<SmartConnectorXMLSchemaLocation> buildXmlSchemaLocations() {
        LinkedList<SmartConnectorXMLSchemaLocation> locations = new LinkedList<SmartConnectorXMLSchemaLocation>();
        for (SmartConnectorSecuritySchemeDecorator scheme : this.securitySchemes) {
            for (SmartConnectorXMLSchemaLocation location : scheme.xmlSchemaLocations) {
                if (locations.contains((Object)location)) continue;
                locations.add(location);
            }
        }
        return locations;
    }

    protected List<SmartConnectorXMLSchema> buildXmlSchemas() {
        LinkedList<SmartConnectorXMLSchema> xmlSchemas = new LinkedList<SmartConnectorXMLSchema>();
        for (SmartConnectorSecuritySchemeDecorator scheme : this.securitySchemes) {
            for (SmartConnectorXMLSchema xmlSchema : scheme.xmlSchemas) {
                if (xmlSchemas.contains((Object)xmlSchema)) continue;
                xmlSchemas.add(xmlSchema);
            }
        }
        return xmlSchemas;
    }

    protected List<SmartConnectorXMLConfig> buildXmlConfigs() {
        LinkedList<SmartConnectorXMLConfig> xmlConfigs = new LinkedList<SmartConnectorXMLConfig>();
        for (SmartConnectorSecuritySchemeDecorator scheme : this.securitySchemes) {
            for (SmartConnectorXMLConfig xmlConfig : scheme.xmlConfigs) {
                if (xmlConfigs.contains((Object)xmlConfig)) continue;
                xmlConfigs.add(xmlConfig);
            }
        }
        return xmlConfigs;
    }

    public String getXmlHttpConfigString(boolean oAuthSchemaExists) {
        StringBuilder builder = new StringBuilder();
        boolean setConnection = true;
        for (SmartConnectorSecuritySchemeDecorator scheme : this.securitySchemes) {
            String xmlHttpConfigString = scheme.getXmlHttpConfigString(this.modulePrefix, setConnection, !oAuthSchemaExists);
            if (!StringUtils.isNotEmpty((CharSequence)xmlHttpConfigString)) continue;
            builder.append(xmlHttpConfigString).append(System.lineSeparator());
            setConnection = false;
        }
        return builder.toString();
    }

    public String getXmlConfigsString() {
        return SmartConnectorSecuritySchemeDecoratorHelper.getXmlConfigsString(this.xmlConfigs);
    }

    public String getXmlSchemasString() {
        return SmartConnectorSecuritySchemeDecoratorHelper.getXmlSchemasString(this.xmlSchemas);
    }

    public String getXmlSchemaLocationsString() {
        return SmartConnectorSecuritySchemeDecoratorHelper.getXmlSchemaLocationsString(this.xmlSchemaLocations);
    }

    public List<SmartConnectorTypeDefinitionDecorator> getConfigProperties() {
        LinkedList<SmartConnectorTypeDefinitionDecorator> allConfigProperties = new LinkedList<SmartConnectorTypeDefinitionDecorator>();
        for (SmartConnectorSecuritySchemeDecorator scheme : this.securitySchemes) {
            allConfigProperties.addAll(scheme.getConfigProperties());
        }
        return allConfigProperties;
    }

    public List<MavenDependency> getPomDependencies() {
        return this.pomDependencies;
    }
}

