/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templateEngine.decorator.type;

import java.io.File;
import java.nio.file.Path;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.exception.GenerationException;
import org.mule.connectivity.restconnect.internal.model.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.model.typesource.PrimitiveTypeSource;
import org.mule.connectivity.restconnect.internal.modelGeneration.util.ParserUtils;
import org.mule.connectivity.restconnect.internal.templateEngine.PojoFQNamePool;
import org.mule.connectivity.restconnect.internal.templateEngine.decorator.type.TypeDefinitionDecorator;
import org.mule.connectivity.restconnect.internal.util.FileGenerationUtils;

public class DevKitConnectorTypeDefinitionDecorator
extends TypeDefinitionDecorator {
    private final String basePackage;
    private String fullQualifiedName;
    private Path pojoLocation;
    private String className;
    private boolean failedToGeneratePojo = false;
    private final PojoFQNamePool pojoFQNamePool;

    public DevKitConnectorTypeDefinitionDecorator(String externalName, String internalName, TypeDefinition typeDefinition, String basePackage, PojoFQNamePool pojoFQNamePool) {
        super(externalName, internalName, typeDefinition);
        this.basePackage = basePackage;
        this.pojoFQNamePool = pojoFQNamePool;
    }

    public DevKitConnectorTypeDefinitionDecorator(TypeDefinition inputMetadata, String basePackage, PojoFQNamePool pojoFQNamePool) {
        super(inputMetadata);
        this.basePackage = basePackage;
        this.pojoFQNamePool = pojoFQNamePool;
    }

    public void generatePojo(Path outputDir) throws GenerationException {
        if (this.pojoFQNamePool.containsTypeDefinition(this.getTypeDefinition())) {
            this.fullQualifiedName = this.pojoFQNamePool.getFullyQualifiedName(this.getTypeDefinition());
        } else {
            this.fullQualifiedName = FileGenerationUtils.generatePojo(this.getTypeDefinition().getSource(), this.getClassName(), outputDir.toFile(), this.basePackage);
            this.pojoFQNamePool.putTypeDefinitionFQNamePair(this.getTypeDefinition(), this.fullQualifiedName);
        }
        this.pojoLocation = outputDir.resolve(this.fullQualifiedName.replace(".", File.separator) + ".java").toAbsolutePath();
    }

    public Path getPojoLocation() {
        return this.pojoLocation;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        if (this.isUnionType() || this.failedToGeneratePojo) {
            return "String";
        }
        if (this.isPrimitiveType()) {
            return this.getJavaPrimitiveType();
        }
        if (StringUtils.isNotBlank((CharSequence)this.fullQualifiedName)) {
            return this.fullQualifiedName;
        }
        return this.className;
    }

    public String getRequestBuilderResponseType() {
        return this.getJavaGenericArgument(this.getClassName());
    }

    private String getJavaGenericArgument(String className) {
        if (className.contains("java.util.List<")) {
            String strippedClassName = className.replaceFirst("java.util.List<", "").replaceFirst(">", "");
            return this.getJavaGenericArgument("java.util.List.class, " + strippedClassName);
        }
        if (className.contains("java.util.Set<")) {
            String strippedClassName = className.replaceFirst("java.util.Set<", "").replaceFirst(">", "");
            return this.getJavaGenericArgument("java.util.Set.class, " + strippedClassName);
        }
        return className + ".class";
    }

    private String getJavaPrimitiveType() {
        PrimitiveTypeSource typeSource = (PrimitiveTypeSource)this.getTypeDefinition().getSource();
        switch (typeSource.getType()) {
            case BOOLEAN: {
                return "Boolean";
            }
            case NUMBER: 
            case INTEGER: {
                return "Double";
            }
            case DATE: 
            case DATE_TIME: 
            case DATE_ONLY: 
            case DATE_TIME_ONLY: 
            case TIME_ONLY: {
                return "Date";
            }
            case FILE: {
                return "File";
            }
            case STRING: {
                return "String";
            }
        }
        throw new IllegalArgumentException("Invalid type value: " + (Object)((Object)typeSource.getType()));
    }

    @Override
    public String getExternalName() {
        return StringEscapeUtils.escapeJava((String)super.getExternalName());
    }

    @Override
    public String getInternalName() {
        return ParserUtils.removeJavaNameUnwantedCharacters(super.getInternalName());
    }

    @Override
    public String getMediaType() {
        return StringEscapeUtils.escapeJava((String)super.getMediaType());
    }

    @Override
    public String getDescription() {
        return StringEscapeUtils.escapeJava((String)super.getDescription());
    }

    @Override
    public String getDefaultValue() {
        return StringEscapeUtils.escapeJava((String)super.getDefaultValue());
    }

    @Override
    public String getExample() {
        return StringEscapeUtils.escapeJava((String)super.getExample());
    }

    public boolean requiresPojo() {
        return this.isEnumType() || !this.isPrimitiveType() && !this.isUnionType() && !this.failedToGeneratePojo;
    }

    public void setFailedToGeneratePojo(boolean failed) {
        this.failedToGeneratePojo = failed;
    }

    public boolean isFailedToGeneratePojo() {
        return this.failedToGeneratePojo;
    }
}

