/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.mojo;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.mule.connectivity.restconnect.api.ConnectorType;
import org.mule.connectivity.restconnect.api.Parser;
import org.mule.connectivity.restconnect.api.RestConnect;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.mule.connectivity.restconnect.internal.util.MojoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="raml2connector", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresProject=false)
public class Raml2ConnectorMojo
extends AbstractMojo {
    private Logger logger = LoggerFactory.getLogger(Raml2ConnectorMojo.class);
    @Parameter(property="raml", required=true)
    private String raml;
    @Parameter(property="name")
    private String name;
    @Parameter(property="outputDir", defaultValue="target")
    private File outputDir;
    @Parameter(property="category", defaultValue="COMMUNITY")
    private String category;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="specFormat", defaultValue="raml")
    private String specFormat;
    @Parameter(property="parser", defaultValue="AMF")
    private String parser;

    public void execute() throws MojoExecutionException {
        try {
            RestConnect.getInstance().createConnectorFromSpec(MojoUtils.getMainRamlFile(this.raml), SpecFormat.getFromString(this.specFormat), Parser.getFromString(this.parser), ConnectorType.DevKitConnector).withApiName(this.name).withCategory(this.category).withOutputDir(this.outputDir.toPath()).withGenerateProjectFiles(this.generateProjectfiles()).run();
        }
        catch (Exception e) {
            this.logger.error("Failed to build connector.", (Throwable)e);
            throw new MojoExecutionException("Failed to build connector", e);
        }
    }

    private boolean generateProjectfiles() {
        return this.project.getBasedir() == null;
    }
}

