/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonData {
    private JsonNode node;

    public JsonData(JsonNode node) {
        this.node = node;
    }

    public JsonData(URL node) throws IOException {
        this(node.openStream());
    }

    public JsonData(InputStream node) throws IOException {
        this.node = new ObjectMapper().readTree(node);
    }

    public JsonData(Reader node) throws IOException {
        this.node = new ObjectMapper().readTree(node);
    }

    public JsonData(String node) throws IOException {
        this(new StringReader(node));
    }

    public JsonNode get(int index) {
        return this.node.get(index);
    }

    public boolean isArray() {
        return this.node.isArray();
    }

    public JsonNode[] toArray() {
        ArrayList children = new ArrayList();
        Iterator itr = this.node.getElements();
        while (itr.hasNext()) {
            children.add(itr.next());
        }
        return children.toArray(new JsonNode[children.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JsonNode get(String expression) {
        List<String> tokens = this.parseTokens(expression);
        JsonNode o = this.node;
        for (String token : tokens) {
            if (token.startsWith("[")) {
                if (!o.isArray()) throw new IllegalArgumentException("Current node is not an array, but expression is expecting one");
                int index = Integer.valueOf(token.substring(1, token.length() - 1));
                o = o.path(index);
            } else {
                o = o.path(token);
            }
            if (!o.isMissingNode()) continue;
            throw new IllegalArgumentException("Not a valid element: " + token);
        }
        return o;
    }

    public String getAsString(String expression) {
        JsonNode node = this.get(expression);
        if (node.isValueNode()) {
            return node.asText();
        }
        return node.toString();
    }

    public boolean hasNode(String key) {
        JsonNode result = this.node.path(key);
        return !result.isMissingNode();
    }

    protected List<String> parseTokens(String expresion) {
        ArrayList<String> tokens = new ArrayList<String>();
        while (expresion.length() > 0) {
            int i;
            int x;
            int slash = expresion.indexOf("/");
            int brace = expresion.indexOf("[");
            if (expresion.charAt(0) == '\'') {
                if (expresion.endsWith("'")) {
                    tokens.add(expresion.substring(1, expresion.length() - 1));
                    expresion = "";
                    continue;
                }
                x = expresion.indexOf("'/");
                tokens.add(expresion.substring(1, x));
                expresion = expresion.substring(x + 2);
                continue;
            }
            if (slash == -1 && brace == -1) {
                tokens.add(expresion);
                expresion = "";
                continue;
            }
            if (slash > -1 && slash < brace || brace == -1) {
                if (slash == 0) {
                    if (expresion.charAt(1) == '\'') {
                        x = expresion.indexOf("'", 2);
                        tokens.add(expresion.substring(2, x));
                        expresion = expresion.substring(x + 1);
                        continue;
                    }
                    if (expresion.charAt(1) == '[') {
                        i = expresion.indexOf("]", 1);
                        tokens.add(expresion.substring(0, i));
                        expresion = expresion.substring(i + 1);
                        continue;
                    }
                    expresion = expresion.substring(slash + 1);
                    continue;
                }
                tokens.add(expresion.substring(0, slash));
                expresion = expresion.substring(slash + 1);
                continue;
            }
            if (brace > 0) {
                tokens.add(expresion.substring(0, brace));
                expresion = expresion.substring(brace);
                continue;
            }
            i = expresion.indexOf("]", brace);
            tokens.add(expresion.substring(0, i + 1));
            expresion = expresion.substring(i + 1);
        }
        return tokens;
    }

    public boolean equals(Object obj) {
        return this.node.equals(obj);
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public String toString() {
        return this.node.toString();
    }
}

