/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.filters;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.XPath;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.api.routing.filter.Filter;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.xml.util.NamespaceManager;
import org.mule.module.xml.util.XMLUtils;
import org.mule.util.ClassUtils;

@Deprecated
public class JXPathFilter
implements Filter,
MuleContextAware,
Initialisable {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String pattern;
    private String expectedValue;
    private Map<String, String> namespaces = null;
    private Map contextProperties = null;
    private AbstractFactory factory;
    private boolean lenient = true;
    private MuleContext muleContext;
    private NamespaceManager namespaceManager;

    public JXPathFilter() {
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void initialise() throws InitialisationException {
        try {
            this.namespaceManager = (NamespaceManager)this.muleContext.getRegistry().lookupObject(NamespaceManager.class);
        }
        catch (RegistrationException e) {
            throw new ExpressionRuntimeException(CoreMessages.failedToLoad((String)"NamespaceManager"), (Throwable)e);
        }
        if (this.namespaceManager != null) {
            if (this.namespaces == null) {
                this.namespaces = new HashMap<String, String>(this.namespaceManager.getNamespaces());
            } else {
                this.namespaces.putAll(this.namespaceManager.getNamespaces());
            }
        }
    }

    public JXPathFilter(String pattern) {
        this.pattern = pattern;
    }

    public JXPathFilter(String pattern, String expectedValue) {
        this.pattern = pattern;
        this.expectedValue = expectedValue;
    }

    public boolean accept(MuleMessage obj) {
        if (obj.getPayload() instanceof byte[]) {
            try {
                return this.accept(obj.getPayloadAsString());
            }
            catch (Exception e) {
                this.logger.warn((Object)("JxPath filter rejected message because it could not convert from byte[] to String: " + e.getMessage()), (Throwable)e);
                return false;
            }
        }
        return this.accept(obj.getPayload());
    }

    private boolean accept(Object obj) {
        Document dom4jDoc;
        if (obj == null) {
            this.logger.warn((Object)"Applying JXPathFilter to null object.");
            return false;
        }
        if (this.pattern == null) {
            this.logger.warn((Object)"Expression for JXPathFilter is not set.");
            return false;
        }
        if (this.expectedValue == null) {
            if (this.pattern.endsWith("= null") || this.pattern.endsWith("=null")) {
                this.expectedValue = "null";
                this.pattern = this.pattern.substring(0, this.pattern.lastIndexOf("="));
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)"Expected value for JXPathFilter is not set, using 'true' by default");
                }
                this.expectedValue = Boolean.TRUE.toString();
            }
        }
        Object xpathResult = null;
        boolean accept = false;
        try {
            dom4jDoc = XMLUtils.toDocument(obj, this.muleContext);
        }
        catch (Exception e) {
            this.logger.warn((Object)("JxPath filter rejected message because of an error while parsing XML: " + e.getMessage()), (Throwable)e);
            return false;
        }
        if (dom4jDoc != null) {
            if (this.namespaces == null) {
                xpathResult = dom4jDoc.valueOf(this.pattern);
            } else {
                XPath xpath = DocumentHelper.createXPath((String)this.pattern);
                xpath.setNamespaceURIs(this.namespaces);
                xpathResult = xpath.valueOf((Object)dom4jDoc);
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Passing object of type " + obj.getClass().getName() + " to JXPathContext"));
            }
            JXPathContext context = JXPathContext.newContext((Object)obj);
            this.initialise(context);
            xpathResult = context.getValue(this.pattern);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("JXPathFilter Expression result = '" + xpathResult + "' -  Expected value = '" + this.expectedValue + "'"));
        }
        if (xpathResult != null) {
            accept = xpathResult.toString().equals(this.expectedValue);
        } else if (this.expectedValue.equals("null")) {
            accept = true;
        } else {
            this.logger.warn((Object)("JXPathFilter expression evaluates to null: " + this.pattern));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("JXPathFilter accept object  : " + accept));
        }
        return accept;
    }

    protected void initialise(JXPathContext context) {
        if (this.namespaces != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Initializing JXPathContext with namespaces: " + this.namespaces));
            }
            for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
                context.registerNamespace(entry.getKey(), entry.getValue());
            }
        }
        if (this.contextProperties != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Initializing JXPathContext with properties: " + this.contextProperties));
            }
            for (Map.Entry entry : this.contextProperties.entrySet()) {
                context.setValue(entry.getKey().toString(), entry.getValue());
            }
        }
        if (this.factory != null) {
            context.setFactory(this.factory);
        }
        context.setLenient(this.lenient);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getExpectedValue() {
        return this.expectedValue;
    }

    public void setExpectedValue(String expectedValue) {
        this.expectedValue = expectedValue;
    }

    @Deprecated
    public String getValue() {
        return this.getExpectedValue();
    }

    @Deprecated
    public void setValue(String value) {
        this.setExpectedValue(value);
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    public Map getContextProperties() {
        return this.contextProperties;
    }

    public void setContextProperties(Map contextProperties) {
        this.contextProperties = contextProperties;
    }

    public AbstractFactory getFactory() {
        return this.factory;
    }

    public void setFactory(AbstractFactory factory) {
        this.factory = factory;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JXPathFilter other = (JXPathFilter)obj;
        return ClassUtils.equal((Object)this.expectedValue, (Object)other.expectedValue) && ClassUtils.equal((Object)this.contextProperties, (Object)other.contextProperties) && ClassUtils.equal(this.namespaces, other.namespaces) && ClassUtils.equal((Object)this.pattern, (Object)other.pattern) && this.lenient == other.lenient;
    }

    public int hashCode() {
        return ClassUtils.hash((Object[])new Object[]{this.getClass(), this.expectedValue, this.contextProperties, this.namespaces, this.pattern, this.lenient});
    }
}

