/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.mule.util.IOUtils;

public class LocalURIResolver
implements URIResolver {
    private String xslFile = null;

    public LocalURIResolver() {
    }

    public LocalURIResolver(String xslFile) {
        this.xslFile = xslFile;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        try {
            int pathPos;
            InputStream is = IOUtils.getResourceAsStream((String)href, this.getClass());
            if (is != null) {
                return new StreamSource(is);
            }
            if (this.xslFile != null && (pathPos = this.xslFile.lastIndexOf(47)) > -1) {
                String path = this.xslFile.substring(0, pathPos + 1);
                return new StreamSource(IOUtils.getResourceAsStream((String)(path + href), this.getClass()));
            }
            throw new TransformerException("Stylesheet not found: " + href);
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
    }
}

