/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el;

import java.util.Collections;
import javax.activation.DataHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.MuleRegistry;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.construct.Flow;
import org.mule.el.context.AbstractELTestCase;
import org.mule.expression.DefaultExpressionManager;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitCleaner;

@SmallTest
public class ExpressionLanguageEnrichmentTestCase
extends AbstractELTestCase {
    protected DefaultExpressionManager expressionManager;
    protected MuleContext muleContext;

    public ExpressionLanguageEnrichmentTestCase(AbstractELTestCase.Variant variant, String mvelOptimizer) {
        super(variant, mvelOptimizer);
    }

    @Before
    public void setup() throws InitialisationException {
        this.expressionManager = new DefaultExpressionManager();
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        MuleRegistry muleRegistry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)new DefaultMuleConfiguration());
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)muleRegistry);
        Mockito.when((Object)muleRegistry.lookupObjectsForLifecycle((Class)Mockito.any(Class.class))).thenReturn(Collections.emptyList());
        this.expressionManager.setMuleContext(this.muleContext);
        this.expressionManager.initialise();
    }

    @Test
    public void enrichReplacePayload() {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"foo", this.muleContext);
        this.expressionManager.enrich("message.payload", (MuleMessage)message, (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)message.getPayload());
    }

    @Test
    public void enrichObjectPayload() {
        Apple apple = new Apple();
        FruitCleaner fruitCleaner = new FruitCleaner(){

            @Override
            public void wash(Fruit fruit) {
            }

            @Override
            public void polish(Fruit fruit) {
            }
        };
        this.expressionManager.enrich("message.payload.appleCleaner", (MuleMessage)new DefaultMuleMessage((Object)apple, this.muleContext), (Object)fruitCleaner);
        Assert.assertEquals((Object)apple.getAppleCleaner(), (Object)fruitCleaner);
    }

    @Test
    public void enrichMessageProperty() {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"foo", this.muleContext);
        this.expressionManager.enrich("message.outboundProperties.foo", (MuleMessage)message, (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)message.getOutboundProperty("foo"));
    }

    @Test
    public void enrichMessageAttachment() {
        DataHandler dataHandler = new DataHandler(new Object(), "test/xml");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"foo", this.muleContext);
        this.expressionManager.enrich("message.outboundAttachments.foo", (MuleMessage)message, (Object)dataHandler);
        Assert.assertEquals((Object)dataHandler, (Object)message.getOutboundAttachment("foo"));
    }

    @Test
    public void enrichFlowVariable() throws Exception {
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"", this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)new Flow("flow", this.muleContext));
        this.expressionManager.enrich("flowVars['foo']", (MuleEvent)event, (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)event.getFlowVariable("foo"));
        Assert.assertNull((Object)event.getSessionVariable("foo"));
    }

    @Test
    public void enrichSessionVariable() throws Exception {
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"", this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)new Flow("flow", this.muleContext));
        this.expressionManager.enrich("sessionVars['foo']", (MuleEvent)event, (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)event.getSessionVariable("foo"));
        Assert.assertNull((Object)event.getFlowVariable("foo"));
    }

    @Test
    public void enrichWithDolarPlaceholder() {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", this.muleContext);
        this.expressionManager.enrich("message.outboundProperties.put('foo', $)", (MuleMessage)message, (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)message.getOutboundProperty("foo"));
    }
}

