/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel.datatype;

import java.nio.charset.StandardCharsets;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.transformer.DataType;
import org.mule.el.mvel.MVELExpressionLanguage;
import org.mule.el.mvel.datatype.PayloadExpressionDataTypeResolver;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.transformer.types.DataTypeFactory;

public class PayloadExpressionDataTypeResolverTestCase
extends AbstractMuleContextTestCase {
    public static final String CUSTOM_ENCODING = StandardCharsets.UTF_16.name();
    private final PayloadExpressionDataTypeResolver dataTypeResolver = new PayloadExpressionDataTypeResolver();

    @Test
    public void returnsPayloadDataType() throws Exception {
        this.doPayloadDataTypeTest("payload");
    }

    @Test
    public void returnsMessagePayloadDataType() throws Exception {
        this.doPayloadDataTypeTest("message.payload");
    }

    private void doPayloadDataTypeTest(String expression) throws Exception {
        DataType expectedDataType = DataTypeFactory.create(String.class, (String)"text/json");
        expectedDataType.setEncoding(CUSTOM_ENCODING);
        MVELExpressionLanguage expressionLanguage = (MVELExpressionLanguage)muleContext.getExpressionLanguage();
        CompiledExpression compiledExpression = (CompiledExpression)MVEL.compileExpression((String)expression, (ParserContext)new ParserContext(expressionLanguage.getParserConfiguration()));
        MuleEvent testEvent = PayloadExpressionDataTypeResolverTestCase.getTestEvent("Test Message");
        testEvent.getMessage().setPayload((Object)"Test Message", expectedDataType);
        MatcherAssert.assertThat((Object)this.dataTypeResolver.resolve(testEvent.getMessage(), compiledExpression), DataTypeMatcher.like(String.class, "text/json", CUSTOM_ENCODING));
    }
}

