/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointMessageProcessorChainFactory;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.endpoint.AbstractEndpoint;
import org.mule.processor.AbstractRedeliveryPolicy;
import org.mule.processor.IdempotentRedeliveryPolicy;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class EndpointTestCase
extends AbstractMuleTestCase {
    @Test
    public void testTransformersAreSetupAfterCompleteEndpointConfig() {
        final Connector mockConnector = (Connector)Mockito.mock(Connector.class);
        final EndpointURI uri = (EndpointURI)Mockito.mock(EndpointURI.class);
        ArrayList<Transformer> inputTransformers = new ArrayList<Transformer>();
        ArrayList<Transformer> outputTransformers = new ArrayList<Transformer>();
        String name = "testEndpoint";
        HashMap<String, String> properties = new HashMap<String, String>();
        String property1 = "property1";
        String value1 = "value1";
        properties.put("property1", "value1");
        final TransactionConfig mockTransactionConfig = (TransactionConfig)Mockito.mock(TransactionConfig.class);
        boolean deleteUnacceptedMessages = true;
        final EndpointSecurityFilter mockEndpointSecurityFilter = (EndpointSecurityFilter)Mockito.mock(EndpointSecurityFilter.class);
        final MessageExchangePattern messageExchangePattern = MessageExchangePattern.REQUEST_RESPONSE;
        int responseTimeout = 5;
        String initialState = "state1";
        String endpointEncoding = "enconding1";
        String endpointBuilderName = "builderName1";
        final MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        final RetryPolicyTemplate retryPolicyTemplate = (RetryPolicyTemplate)Mockito.mock(RetryPolicyTemplate.class);
        final AbstractRedeliveryPolicy redeliveryPolicy = (AbstractRedeliveryPolicy)Mockito.mock(IdempotentRedeliveryPolicy.class);
        EndpointMessageProcessorChainFactory messageProcessorsFactory = (EndpointMessageProcessorChainFactory)Mockito.mock(EndpointMessageProcessorChainFactory.class);
        ArrayList messageProcessors = new ArrayList();
        ArrayList responseMessageProcessors = new ArrayList();
        String mimeType = "text/plain";
        boolean disableTransportTransformer = true;
        Transformer mockTransformer = (Transformer)Mockito.mock(Transformer.class);
        ((Transformer)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                AbstractEndpoint endpoint = (AbstractEndpoint)invocation.getArguments()[0];
                Assert.assertEquals((Object)mockConnector, (Object)endpoint.getConnector());
                Assert.assertEquals((Object)uri, (Object)endpoint.getEndpointURI());
                Assert.assertEquals((Object)"testEndpoint", (Object)endpoint.getName());
                Assert.assertEquals((Object)"value1", endpoint.getProperties().get("property1"));
                Assert.assertEquals((Object)mockTransactionConfig, (Object)endpoint.getTransactionConfig());
                Assert.assertEquals((Object)true, (Object)endpoint.isDeleteUnacceptedMessages());
                Assert.assertEquals((Object)mockEndpointSecurityFilter, (Object)endpoint.getSecurityFilter());
                Assert.assertEquals((Object)messageExchangePattern, (Object)endpoint.getExchangePattern());
                Assert.assertEquals((long)5L, (long)endpoint.getResponseTimeout());
                Assert.assertEquals((Object)"state1", (Object)endpoint.getInitialState());
                Assert.assertEquals((Object)"enconding1", (Object)endpoint.getEncoding());
                Assert.assertEquals((Object)"builderName1", (Object)endpoint.getEndpointBuilderName());
                Assert.assertEquals((Object)muleContext, (Object)endpoint.getMuleContext());
                Assert.assertEquals((Object)retryPolicyTemplate, (Object)endpoint.getRetryPolicyTemplate());
                Assert.assertEquals((Object)redeliveryPolicy, (Object)endpoint.getRedeliveryPolicy());
                Assert.assertEquals((Object)"text/plain", (Object)endpoint.getMimeType());
                Assert.assertEquals((Object)true, (Object)endpoint.isDisableTransportTransformer());
                return null;
            }
        }).when((Object)mockTransformer)).setEndpoint((ImmutableEndpoint)Matchers.any(ImmutableEndpoint.class));
        inputTransformers.add(mockTransformer);
        outputTransformers.add(mockTransformer);
        new AbstractEndpoint(mockConnector, uri, "testEndpoint", properties, mockTransactionConfig, true, messageExchangePattern, 5, "state1", "enconding1", "builderName1", muleContext, retryPolicyTemplate, redeliveryPolicy, messageProcessorsFactory, messageProcessors, responseMessageProcessors, true, "text/plain"){

            protected MessageProcessor createMessageProcessorChain(FlowConstruct flowConstruct) throws MuleException {
                return null;
            }
        };
    }
}

