/*
 * Decompiled with CFR 0.152.
 */
package org.mule.message.processing;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.execution.EndPhaseTemplate;
import org.mule.execution.FlowProcessingPhase;
import org.mule.execution.FlowProcessingPhaseTemplate;
import org.mule.execution.MessageProcessContext;
import org.mule.execution.MessageProcessPhase;
import org.mule.execution.MessageProcessTemplate;
import org.mule.execution.MuleMessageProcessingManager;
import org.mule.execution.PhaseResultNotifier;
import org.mule.execution.ValidationPhase;
import org.mule.execution.ValidationPhaseTemplate;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class MuleMessageProcessingManagerTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext mockMuleContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private TestMessageProcessTemplateAndContext completeMessageProcessTemplateAndContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private SystemExceptionHandler mockExceptionListener;

    @Test
    public void nullMessageProcessPhaseInRegistry() throws Exception {
        this.processAndVerifyDefaultPhasesUsingRegistryPhases(null);
    }

    @Test
    public void emptyMessageProcessPhaseInRegistry() throws Exception {
        this.processAndVerifyDefaultPhasesUsingRegistryPhases(Collections.emptyList());
    }

    @Test
    public void notSupportedMessageProcessPhaseInRegistry() throws Exception {
        MessageProcessPhase notSupportedPhase = this.createNotSupportedPhase();
        this.processAndVerifyDefaultPhasesUsingRegistryPhases(Arrays.asList(notSupportedPhase));
    }

    @Test
    public void messageConsumedPreventsNextPhaseToBeExecuted() throws Exception {
        PhaseAfterValidationBeforeFlow messageProcessPhase = this.createPhaseAfterValidation();
        Mockito.when((Object)this.completeMessageProcessTemplateAndContext.validateMessage()).thenReturn((Object)true);
        Mockito.when((Object)messageProcessPhase.compareTo((MessageProcessPhase)Matchers.any(MessageProcessPhase.class))).thenCallRealMethod();
        Mockito.when((Object)messageProcessPhase.supportsTemplate((MessageProcessTemplate)Matchers.any(MessageProcessTemplate.class))).thenCallRealMethod();
        ((PhaseAfterValidationBeforeFlow)Mockito.doCallRealMethod().when((Object)messageProcessPhase)).runPhase((MessageProcessTemplate)Matchers.any(MessageProcessTemplate.class), (MessageProcessContext)Matchers.any(MessageProcessContext.class), (PhaseResultNotifier)Matchers.any(PhaseResultNotifier.class));
        MuleMessageProcessingManager manager = this.createManagerUsingPhasesInRegistry(Arrays.asList(messageProcessPhase));
        manager.processMessage((MessageProcessTemplate)this.completeMessageProcessTemplateAndContext, (MessageProcessContext)this.completeMessageProcessTemplateAndContext);
        ((TestMessageProcessTemplateAndContext)Mockito.verify((Object)this.completeMessageProcessTemplateAndContext, (VerificationMode)Mockito.times((int)0))).routeEvent((MuleEvent)Matchers.any(MuleEvent.class));
        ((TestMessageProcessTemplateAndContext)Mockito.verify((Object)this.completeMessageProcessTemplateAndContext, (VerificationMode)Mockito.times((int)1))).validateMessage();
        ((TestMessageProcessTemplateAndContext)Mockito.verify((Object)this.completeMessageProcessTemplateAndContext, (VerificationMode)Mockito.times((int)1))).messageProcessingEnded();
    }

    private PhaseAfterValidationBeforeFlow createPhaseAfterValidation() {
        return (PhaseAfterValidationBeforeFlow)Mockito.mock(PhaseAfterValidationBeforeFlow.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    }

    @Test
    public void testExceptionHandlerIsCalledDuringPhaseFailure() throws Exception {
        MessageProcessPhase failureMessageProcessPhase = this.createFailureMessageProcessPhase();
        Mockito.when((Object)this.mockMuleContext.getExceptionListener()).thenReturn((Object)this.mockExceptionListener);
        MuleMessageProcessingManager manager = this.createManagerUsingPhasesInRegistry(Arrays.asList(failureMessageProcessPhase));
        manager.processMessage((MessageProcessTemplate)this.completeMessageProcessTemplateAndContext, (MessageProcessContext)this.completeMessageProcessTemplateAndContext);
        ((SystemExceptionHandler)Mockito.verify((Object)this.mockExceptionListener, (VerificationMode)Mockito.times((int)1))).handleException((Exception)Matchers.any(MuleException.class));
    }

    private MessageProcessPhase createFailureMessageProcessPhase() {
        FailureMessageProcessPhase failureMessageProcessPhase = (FailureMessageProcessPhase)Mockito.mock(FailureMessageProcessPhase.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        Mockito.when((Object)failureMessageProcessPhase.supportsTemplate((MessageProcessTemplate)Matchers.any(MessageProcessTemplate.class))).thenCallRealMethod();
        ((FailureMessageProcessPhase)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                PhaseResultNotifier phaseResultNotifier = (PhaseResultNotifier)invocationOnMock.getArguments()[2];
                phaseResultNotifier.phaseFailure((Exception)new DefaultMuleException("error"));
                return null;
            }
        }).when((Object)failureMessageProcessPhase)).runPhase((MessageProcessTemplate)Matchers.any(MessageProcessTemplate.class), (MessageProcessContext)Matchers.any(MessageProcessContext.class), (PhaseResultNotifier)Matchers.any(PhaseResultNotifier.class));
        return failureMessageProcessPhase;
    }

    private MessageProcessPhase createNotSupportedPhase() {
        MessageProcessPhase notSupportedPhase = (MessageProcessPhase)Mockito.mock(MessageProcessPhase.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        Mockito.when((Object)notSupportedPhase.supportsTemplate((MessageProcessTemplate)Matchers.any(MessageProcessTemplate.class))).thenReturn((Object)false);
        return notSupportedPhase;
    }

    private void processAndVerifyDefaultPhasesUsingRegistryPhases(Collection<MessageProcessPhase> phasesInRegistry) throws Exception {
        MuleMessageProcessingManager manager = this.createManagerUsingPhasesInRegistry(phasesInRegistry);
        this.processAndVerifyDefaultPhasesAreExecuted(manager);
    }

    private MuleMessageProcessingManager createManagerUsingPhasesInRegistry(Collection<MessageProcessPhase> phasesInRegistry) throws InitialisationException {
        MuleMessageProcessingManager manager = new MuleMessageProcessingManager();
        manager.setMuleContext(this.mockMuleContext);
        Mockito.when((Object)this.mockMuleContext.getRegistry().lookupObjects(MessageProcessPhase.class)).thenReturn(phasesInRegistry);
        manager.initialise();
        return manager;
    }

    private void processAndVerifyDefaultPhasesAreExecuted(MuleMessageProcessingManager manager) throws Exception {
        Mockito.when((Object)this.completeMessageProcessTemplateAndContext.validateMessage()).thenReturn((Object)true);
        manager.processMessage((MessageProcessTemplate)this.completeMessageProcessTemplateAndContext, (MessageProcessContext)this.completeMessageProcessTemplateAndContext);
        InOrder verifyInOrder = Mockito.inOrder((Object[])new Object[]{this.completeMessageProcessTemplateAndContext});
        ((TestMessageProcessTemplateAndContext)verifyInOrder.verify((Object)this.completeMessageProcessTemplateAndContext, Mockito.times((int)1))).validateMessage();
        ((TestMessageProcessTemplateAndContext)verifyInOrder.verify((Object)this.completeMessageProcessTemplateAndContext, Mockito.times((int)1))).routeEvent((MuleEvent)Mockito.any(MuleEvent.class));
        ((TestMessageProcessTemplateAndContext)verifyInOrder.verify((Object)this.completeMessageProcessTemplateAndContext, Mockito.times((int)1))).messageProcessingEnded();
    }

    public abstract class FailureMessageProcessPhase
    implements MessageProcessPhase,
    Comparable<MessageProcessPhase> {
        public boolean supportsTemplate(MessageProcessTemplate messageProcessTemplate) {
            return true;
        }

        @Override
        public int compareTo(MessageProcessPhase messageProcessPhase) {
            return -1;
        }
    }

    public abstract class PhaseAfterValidationBeforeFlow
    implements MessageProcessPhase,
    Comparable<MessageProcessPhase> {
        public boolean supportsTemplate(MessageProcessTemplate messageProcessTemplate) {
            return true;
        }

        @Override
        public int compareTo(MessageProcessPhase messageProcessPhase) {
            if (messageProcessPhase instanceof ValidationPhase) {
                return 1;
            }
            if (messageProcessPhase instanceof FlowProcessingPhase) {
                return -1;
            }
            return 0;
        }

        public void runPhase(MessageProcessTemplate messageProcessTemplate, MessageProcessContext messageProcessContext, PhaseResultNotifier phaseResultNotifier) {
            phaseResultNotifier.phaseConsumedMessage();
        }
    }

    public static interface TestMessageProcessTemplateAndContext
    extends ValidationPhaseTemplate,
    FlowProcessingPhaseTemplate,
    EndPhaseTemplate,
    MessageProcessContext {
    }
}

