/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model.seda;

import java.util.concurrent.TimeUnit;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEventContext;
import org.mule.api.component.Component;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.lifecycle.Callable;
import org.mule.api.model.Model;
import org.mule.api.object.ObjectFactory;
import org.mule.api.registry.RegistrationException;
import org.mule.api.service.Service;
import org.mule.api.store.QueueStore;
import org.mule.component.DefaultJavaComponent;
import org.mule.component.SimpleCallableJavaComponent;
import org.mule.config.ChainedThreadingProfile;
import org.mule.config.QueueProfile;
import org.mule.model.AbstractServiceTestCase;
import org.mule.model.seda.SedaModel;
import org.mule.model.seda.SedaService;
import org.mule.object.PrototypeObjectFactory;
import org.mule.tck.MuleTestUtils;
import org.mule.util.concurrent.Latch;
import org.mule.util.queue.QueueManager;

public class SedaServiceTestCase
extends AbstractServiceTestCase {
    private SedaService service;

    public SedaServiceTestCase() {
        this.setStartContext(true);
    }

    @Override
    protected void doSetUp() throws Exception {
        this.service = new SedaService(muleContext);
        this.service.setName("test");
        PrototypeObjectFactory factory = new PrototypeObjectFactory(Object.class);
        this.service.setComponent((Component)new DefaultJavaComponent((ObjectFactory)factory));
        this.service.setModel((Model)new SedaModel());
        this.service.getModel().setMuleContext(muleContext);
        this.service.getModel().initialise();
    }

    @Override
    protected Service getService() {
        return this.service;
    }

    @Test
    public void testQueueConfiguration() throws Exception {
        int capacity = 345;
        QueueManager queueManager = muleContext.getQueueManager();
        QueueManager mockTransactionalQueueManager = (QueueManager)Mockito.mock(QueueManager.class);
        Mockito.when((Object)mockTransactionalQueueManager.getQueueSession()).thenReturn((Object)queueManager.getQueueSession());
        muleContext.getRegistry().registerObject("_muleQueueManager", (Object)mockTransactionalQueueManager);
        QueueStore objectStore = (QueueStore)muleContext.getRegistry().lookupObject("_defaultPersistentQueueStore");
        this.service.setQueueProfile(new QueueProfile(capacity, objectStore));
        try {
            muleContext.getRegistry().registerService((Service)this.service);
        }
        catch (RegistrationException e) {
            if (e.getCause().getCause().getCause() instanceof AssertionFailedError) {
                Assert.fail((String)"Queue configuration does not match service queue profile");
            }
            throw e;
        }
    }

    @Test
    public void testSedaModelEventTimeoutDefault() throws Exception {
        this.service.initialise();
        Assert.assertNotNull((Object)this.service.getQueueTimeout());
        Assert.assertTrue((this.service.getQueueTimeout() != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDispatchToPausedService() throws Exception {
        this.service.initialise();
        this.service.start();
        this.service.pause();
        this.service.process(MuleTestUtils.getTestEvent((Object)"test", SedaServiceTestCase.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY), muleContext));
    }

    @Test
    public void testMaxActiveThreadsEqualsOneWhenExhaustedActionWait() throws Exception {
        final Latch latch = new Latch();
        this.service.setName("testMaxActiveThreadsEqualsOne");
        ChainedThreadingProfile threadingProfile = (ChainedThreadingProfile)muleContext.getDefaultServiceThreadingProfile();
        threadingProfile.setMaxThreadsActive(1);
        threadingProfile.setThreadWaitTimeout(200L);
        threadingProfile.setPoolExhaustedAction(0);
        this.service.setThreadingProfile((ThreadingProfile)threadingProfile);
        SimpleCallableJavaComponent component = new SimpleCallableJavaComponent(new Callable(){

            public Object onCall(MuleEventContext eventContext) throws Exception {
                latch.countDown();
                return null;
            }
        });
        component.setMuleContext(muleContext);
        this.service.setComponent((Component)component);
        muleContext.getRegistry().registerService((Service)this.service);
        this.service.process(MuleTestUtils.getTestEvent((Object)"test", (Service)this.service, muleContext));
        Assert.assertTrue((boolean)latch.await(200L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testDoThreadingFalse() throws Exception {
        final Latch latch = new Latch();
        String serviceName = "testDoThreadingFalse";
        this.service.setName("testDoThreadingFalse");
        ChainedThreadingProfile threadingProfile = (ChainedThreadingProfile)muleContext.getDefaultServiceThreadingProfile();
        threadingProfile.setDoThreading(false);
        this.service.setThreadingProfile((ThreadingProfile)threadingProfile);
        final Thread mainThread = Thread.currentThread();
        SimpleCallableJavaComponent component = new SimpleCallableJavaComponent(new Callable(){

            public Object onCall(MuleEventContext eventContext) throws Exception {
                Assert.assertEquals((Object)mainThread, (Object)Thread.currentThread());
                latch.countDown();
                return null;
            }
        });
        component.setMuleContext(muleContext);
        this.service.setComponent((Component)component);
        muleContext.getRegistry().registerService((Service)this.service);
        this.service.process(MuleTestUtils.getTestEvent((Object)"test", SedaServiceTestCase.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY), muleContext));
        Assert.assertTrue((boolean)latch.await(200L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testDoThreadingTrue() throws Exception {
        final Latch latch = new Latch();
        String serviceName = "testDoThreadingFalse";
        this.service.setName("testDoThreadingFalse");
        ChainedThreadingProfile threadingProfile = (ChainedThreadingProfile)muleContext.getDefaultServiceThreadingProfile();
        threadingProfile.setDoThreading(true);
        this.service.setThreadingProfile((ThreadingProfile)threadingProfile);
        SimpleCallableJavaComponent component = new SimpleCallableJavaComponent(new Callable(){

            public Object onCall(MuleEventContext eventContext) throws Exception {
                System.out.println(Thread.currentThread().getName());
                Assert.assertTrue((boolean)Thread.currentThread().getName().startsWith("testDoThreadingFalse"));
                latch.countDown();
                return null;
            }
        });
        component.setMuleContext(muleContext);
        this.service.setComponent((Component)component);
        muleContext.getRegistry().registerService((Service)this.service);
        this.service.process(MuleTestUtils.getTestEvent((Object)"test", SedaServiceTestCase.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY), muleContext));
        Assert.assertTrue((boolean)latch.await(200L, TimeUnit.MILLISECONDS));
    }
}

