/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mule.enricher;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.DataType;
import org.mule.api.transport.PropertyScope;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.enricher.MessageEnricher;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.transformer.simple.StringAppendTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class MessageEnricherTestCase
extends AbstractMuleContextTestCase {
    public static final String FOO_FLOW_VAR_EXPRESSION = "#[flowVars['foo']]";

    @Test
    public void testEnrichHeaderWithPayload() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)"test");
                return event;
            }
        });
        enricher.initialise();
        MuleMessage result = enricher.process(MessageEnricherTestCase.getTestEvent("")).getMessage();
        Assert.assertEquals((Object)"test", (Object)result.getOutboundProperty("myHeader"));
        Assert.assertEquals((Object)"", (Object)result.getPayload());
    }

    @Test
    public void testEnrichHeaderWithHeader() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:header1]", "#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setOutboundProperty("header1", (Object)"test");
                return event;
            }
        });
        MuleMessage result = enricher.process(MessageEnricherTestCase.getTestEvent("")).getMessage();
        Assert.assertEquals((Object)"test", (Object)result.getOutboundProperty("myHeader"));
        Assert.assertEquals((Object)"", (Object)result.getPayload());
    }

    @Test
    public void testEnrichHeadersMToN() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:header1]", "#[header:myHeader1]"));
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:header2]", "#[header:myHeader2]"));
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:header3]", "#[header:myHeader3]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setOutboundProperty("header1", (Object)"test");
                event.getMessage().setOutboundProperty("header2", (Object)"test2");
                event.getMessage().setOutboundProperty("header3", (Object)"test3");
                return event;
            }
        });
        MuleMessage result = enricher.process(MessageEnricherTestCase.getTestEvent("")).getMessage();
        Assert.assertNull((Object)result.getOutboundProperty("myHeader"));
        Assert.assertEquals((Object)"test2", (Object)result.getOutboundProperty("myHeader2"));
        Assert.assertEquals((Object)"test3", (Object)result.getOutboundProperty("myHeader3"));
        Assert.assertEquals((Object)"", (Object)result.getPayload());
    }

    @Test
    public void testEnrichHeaderNestedEvaluator() throws Exception {
        muleContext.getRegistry().registerObject("appender", (Object)new StringAppendTransformer(" append"));
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[process:appender:#[header:header1]]", "#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setOutboundProperty("header1", (Object)"test");
                return event;
            }
        });
        MuleEvent event = MessageEnricherTestCase.getTestEvent("");
        RequestContext.setEvent((MuleEvent)event);
        Assert.assertEquals((Object)"test append", (Object)enricher.process(MessageEnricherTestCase.getTestEvent("")).getMessage().getOutboundProperty("myHeader"));
    }

    @Test
    public void testEnrichWithNullResponse() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                return null;
            }
        });
        MuleMessage result = enricher.process(MessageEnricherTestCase.getTestEvent("")).getMessage();
        Assert.assertNull((Object)result.getOutboundProperty("myHeader"));
        Assert.assertEquals((Object)"", (Object)result.getPayload());
    }

    @Test
    public void propogateMessage() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)"enriched");
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        in.getMessage().setOutboundProperty("foo", (Object)"bar");
        MuleEvent out = enricher.process(in);
        junit.framework.Assert.assertSame((Object)in, (Object)out);
        junit.framework.Assert.assertSame((Object)in.getMessage(), (Object)out.getMessage());
        Assert.assertEquals((Object)in.getMessage().getUniqueId(), (Object)out.getMessage().getUniqueId());
        Assert.assertEquals((Object)in.getMessage().getPropertyNames(), (Object)out.getMessage().getPropertyNames());
        Assert.assertEquals((Object)"bar", (Object)out.getMessage().getOutboundProperty("foo"));
        Assert.assertEquals((Object)in.getMessage().getPayload(), (Object)out.getMessage().getPayload());
    }

    @Test
    public void propogateMessagePropagateSession() throws Exception {
        ((DefaultMuleConfiguration)muleContext.getConfiguration()).setEnricherPropagatesSessionVariableChanges(true);
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)"enriched");
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        in.getMessage().setOutboundProperty("foo", (Object)"bar");
        MuleEvent out = enricher.process(in);
        junit.framework.Assert.assertNotSame((Object)in, (Object)out);
        junit.framework.Assert.assertSame((Object)in.getMessage(), (Object)out.getMessage());
        Assert.assertEquals((Object)in.getMessage().getUniqueId(), (Object)out.getMessage().getUniqueId());
        Assert.assertEquals((Object)in.getMessage().getPropertyNames(), (Object)out.getMessage().getPropertyNames());
        Assert.assertEquals((Object)"bar", (Object)out.getMessage().getOutboundProperty("foo"));
        Assert.assertEquals((Object)"", (Object)out.getMessage().getPayload());
    }

    @Test
    public void propagatesVariables() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)"enriched");
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        in.getSession().setProperty("sessionFoo", (Serializable)((Object)"bar"));
        in.getMessage().setInvocationProperty("flowFoo", (Object)"bar");
        MuleEvent out = enricher.process(in);
        Assert.assertEquals((Object)"bar", (Object)out.getSession().getProperty("sessionFoo"));
        Assert.assertEquals((Object)"bar", (Object)out.getMessage().getInvocationProperty("flowFoo"));
    }

    @Test
    public void doNotImplicitlyEnrichMessagePayload() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)"enriched");
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        MuleEvent out = enricher.process(in);
        Assert.assertEquals((Object)"", (Object)out.getMessage().getPayload());
    }

    @Test
    public void doNotImplicitlyEnrichMessageProperties() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setOutboundProperty("foo", (Object)"bar");
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        MuleEvent out = enricher.process(in);
        Assert.assertNull((Object)out.getMessage().getOutboundProperty("foo"));
    }

    @Test
    public void doNotImplicitlyEnrichFlowVariable() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setInvocationProperty("flowFoo", (Object)"bar");
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        MuleEvent out = enricher.process(in);
        Assert.assertNull((Object)out.getMessage().getInvocationProperty("flowFoo"));
    }

    @Test
    public void doNotImplicitlyEnrichSessionVariable() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getSession().setProperty("sessionFoo", (Serializable)((Object)"bar"));
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        MuleEvent out = enricher.process(in);
        Assert.assertNull((Object)out.getSession().getProperty("sessionFoo"));
    }

    @Test
    public void propagatesSession() throws Exception {
        ((DefaultMuleConfiguration)muleContext.getConfiguration()).setEnricherPropagatesSessionVariableChanges(true);
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getSession().setProperty("sessionFoo", (Serializable)((Object)"bar"));
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        MuleEvent out = enricher.process(in);
        Assert.assertEquals((Object)"bar", (Object)out.getSession().getProperty("sessionFoo"));
    }

    @Test
    public void enrichFlowVariable() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[variable:foo]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)"bar");
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        MuleEvent out = enricher.process(in);
        Assert.assertEquals((Object)"bar", (Object)out.getMessage().getInvocationProperty("foo"));
    }

    @Test
    public void enrichSessionVariable() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[sessionVars['foo']]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)"bar");
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        MuleEvent out = enricher.process(in);
        Assert.assertEquals((Object)"bar", (Object)out.getSessionVariable("foo"));
    }

    @Test
    public void enrichesFlowVarWithDataType() throws Exception {
        this.doEnrichDataTypePropagationTest(new MessageEnricher.EnrichExpressionPair("#[payload]", FOO_FLOW_VAR_EXPRESSION));
    }

    @Test
    public void enrichesFlowVarWithDataTypeUsingExpressionEvaluator() throws Exception {
        this.doEnrichDataTypePropagationTest(new MessageEnricher.EnrichExpressionPair(FOO_FLOW_VAR_EXPRESSION));
    }

    private void doEnrichDataTypePropagationTest(MessageEnricher.EnrichExpressionPair pair) throws Exception {
        final DataType dataType = DataTypeFactory.create(String.class, (String)"text/json");
        dataType.setEncoding(StandardCharsets.UTF_16.name());
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(pair);
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)"bar", dataType);
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        MuleEvent out = enricher.process(in);
        Assert.assertEquals((Object)"bar", (Object)out.getMessage().getInvocationProperty("foo"));
        Assert.assertThat((Object)out.getMessage().getPropertyDataType("foo", PropertyScope.INVOCATION), DataTypeMatcher.like(String.class, "text/json", StandardCharsets.UTF_16.name()));
    }
}

