/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mule.model;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.model.InvocationResult;
import org.mule.model.resolvers.NoArgumentsEntryPointResolver;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.InvalidSatsuma;
import org.mule.transport.NullPayload;

public class NoArgsEntryPointResolverTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testExplicitMethodMatch() throws Exception {
        NoArgumentsEntryPointResolver resolver = new NoArgumentsEntryPointResolver();
        resolver.addMethod("bite");
        InvocationResult result = resolver.invoke((Object)new InvalidSatsuma(), NoArgsEntryPointResolverTestCase.getTestEventContext("blah"));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    @Test
    public void testExplicitMethodMatch2() throws Exception {
        NoArgumentsEntryPointResolver resolver = new NoArgumentsEntryPointResolver();
        resolver.addMethod("wash");
        InvocationResult result = resolver.invoke((Object)new Apple(), NoArgsEntryPointResolverTestCase.getTestEventContext("blah"));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    @Test
    public void testDynamicMethodMatchFail() throws Exception {
        NoArgumentsEntryPointResolver resolver = new NoArgumentsEntryPointResolver();
        InvocationResult result = resolver.invoke((Object)new Apple(), NoArgsEntryPointResolverTestCase.getTestEventContext("blah"));
        Assert.assertEquals((String)"Apple service has a number of matching method, so should have failed", (Object)result.getState(), (Object)InvocationResult.State.FAILED);
    }

    @Test
    public void testDynamicMethodMatchPass() throws Exception {
        NoArgumentsEntryPointResolver resolver = new NoArgumentsEntryPointResolver();
        InvocationResult result = resolver.invoke((Object)new InvalidSatsuma(), NoArgsEntryPointResolverTestCase.getTestEventContext("blah"));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    @Test
    public void testDynamicMethodMatchFailOnWildcardMatch() throws Exception {
        NoArgumentsEntryPointResolver resolver = new NoArgumentsEntryPointResolver();
        Assert.assertTrue((boolean)resolver.removeIgnoredMethod("is*"));
        InvocationResult result = resolver.invoke((Object)new InvalidSatsuma(), NoArgsEntryPointResolverTestCase.getTestEventContext("blah"));
        Assert.assertEquals((String)"Satsuma service has a number of matching method, so should have failed", (Object)result.getState(), (Object)InvocationResult.State.FAILED);
    }

    @Test
    public void testExplicitMethodMatchAndNullPayload() throws Exception {
        NoArgumentsEntryPointResolver resolver = new NoArgumentsEntryPointResolver();
        resolver.addMethod("wash");
        InvocationResult result = resolver.invoke((Object)new Apple(), NoArgsEntryPointResolverTestCase.getTestEventContext(NullPayload.getInstance()));
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }
}

