/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.beans.ExceptionListener;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.WorkManager;
import org.mule.api.context.WorkManagerSource;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.api.transaction.Transaction;
import org.mule.construct.Flow;
import org.mule.processor.AsyncDelegateMessageProcessor;
import org.mule.processor.strategy.AsynchronousProcessingStrategy;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.mule.TestTransaction;
import org.mule.transaction.TransactionCoordination;
import org.mule.util.concurrent.Latch;

public class AsyncDelegateMessageProcessorTestCase
extends AbstractMuleContextTestCase
implements ExceptionListener {
    protected AsyncDelegateMessageProcessor messageProcessor;
    protected TestListener target = new TestListener();
    protected Exception exceptionThrown;
    protected Latch latch = new Latch();

    public AsyncDelegateMessageProcessorTestCase() {
        this.setStartContext(true);
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.messageProcessor = this.createAsyncDelegatMessageProcessor(this.target);
        this.messageProcessor.initialise();
        this.messageProcessor.start();
    }

    @Test
    public void testProcessOneWay() throws Exception {
        MuleEvent event = AsyncDelegateMessageProcessorTestCase.getTestEvent((Object)"Test Message", AsyncDelegateMessageProcessorTestCase.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY));
        MuleEvent result = this.messageProcessor.process(event);
        this.latch.await(10000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)this.target.sensedEvent);
        Assert.assertNotSame((Object)event, (Object)this.target.sensedEvent);
        Assert.assertEquals((Object)event.getMessageAsString(), (Object)this.target.sensedEvent.getMessageAsString());
        Assert.assertSame((Object)VoidMuleEvent.getInstance(), (Object)result);
        Assert.assertNull((Object)this.exceptionThrown);
        Assert.assertNotSame((Object)Thread.currentThread(), (Object)this.target.thread);
        this.messageProcessor.stop();
        this.messageProcessor.dispose();
    }

    @Test
    public void testProcessRequestResponse() throws Exception {
        MuleEvent event = AsyncDelegateMessageProcessorTestCase.getTestEvent((Object)"Test Message", AsyncDelegateMessageProcessorTestCase.getTestInboundEndpoint(MessageExchangePattern.REQUEST_RESPONSE));
        MuleEvent result = this.messageProcessor.process(event);
        this.latch.await(10000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)this.target.sensedEvent);
        Assert.assertNotSame((Object)event, (Object)this.target.sensedEvent);
        Assert.assertEquals((Object)event.getMessageAsString(), (Object)this.target.sensedEvent.getMessageAsString());
        Assert.assertSame((Object)VoidMuleEvent.getInstance(), (Object)result);
        Assert.assertNull((Object)this.exceptionThrown);
        Assert.assertNotSame((Object)Thread.currentThread(), (Object)this.target.thread);
        this.messageProcessor.stop();
        this.messageProcessor.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessOneWayWithTx() throws Exception {
        MuleEvent event = AsyncDelegateMessageProcessorTestCase.getTestEvent((Object)"Test Message", AsyncDelegateMessageProcessorTestCase.getTestTransactedInboundEndpoint(MessageExchangePattern.ONE_WAY));
        TestTransaction transaction = new TestTransaction(muleContext);
        TransactionCoordination.getInstance().bindTransaction((Transaction)transaction);
        try {
            this.messageProcessor.process(event);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof MessagingException));
            Assert.assertNull((Object)this.target.sensedEvent);
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction((Transaction)transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessRequestResponseWithTx() throws Exception {
        MuleEvent event = AsyncDelegateMessageProcessorTestCase.getTestEvent((Object)"Test Message", AsyncDelegateMessageProcessorTestCase.getTestTransactedInboundEndpoint(MessageExchangePattern.REQUEST_RESPONSE));
        TestTransaction transaction = new TestTransaction(muleContext);
        TransactionCoordination.getInstance().bindTransaction((Transaction)transaction);
        try {
            this.assertAsync((MessageProcessor)this.messageProcessor, event);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction((Transaction)transaction);
        }
    }

    protected void assertSync(MessageProcessor processor, MuleEvent event) throws MuleException {
        MuleEvent result = processor.process(event);
        Assert.assertSame((Object)event, (Object)this.target.sensedEvent);
        Assert.assertSame((Object)event, (Object)result);
    }

    protected void assertAsync(MessageProcessor processor, MuleEvent event) throws MuleException, InterruptedException {
        MuleEvent result = processor.process(event);
        this.latch.await(10000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)this.target.sensedEvent);
        Assert.assertNotSame((Object)event, (Object)this.target.sensedEvent);
        Assert.assertEquals((Object)event.getMessageAsString(), (Object)this.target.sensedEvent.getMessageAsString());
        Assert.assertNull((Object)result);
        Assert.assertNull((Object)this.exceptionThrown);
    }

    protected AsyncDelegateMessageProcessor createAsyncDelegatMessageProcessor(MessageProcessor listener) throws Exception {
        AsyncDelegateMessageProcessor mp = new AsyncDelegateMessageProcessor(listener, (ProcessingStrategy)new AsynchronousProcessingStrategy(), "thread");
        mp.setMuleContext(muleContext);
        mp.setFlowConstruct((FlowConstruct)new Flow("flow", muleContext));
        mp.initialise();
        return mp;
    }

    @Override
    public void exceptionThrown(Exception e) {
        this.exceptionThrown = e;
    }

    class TestWorkManagerSource
    implements WorkManagerSource {
        TestWorkManagerSource() {
        }

        public WorkManager getWorkManager() throws MuleException {
            return muleContext.getWorkManager();
        }
    }

    class TestListener
    implements MessageProcessor {
        MuleEvent sensedEvent;
        Thread thread;

        TestListener() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            this.sensedEvent = event;
            this.thread = Thread.currentThread();
            AsyncDelegateMessageProcessorTestCase.this.latch.countDown();
            return event;
        }
    }
}

