/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.endpoint.AbstractMessageProcessorTestCase;
import org.mule.processor.ExceptionHandlingMessageProcessor;
import org.mule.transport.NullPayload;

@Ignore
public class ExceptionHandlingMessageProcessorTestCase
extends AbstractMessageProcessorTestCase {
    private AbstractMessageProcessorTestCase.TestExceptionListener exceptionListener;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.exceptionListener = new AbstractMessageProcessorTestCase.TestExceptionListener();
    }

    @Test
    public void testNoCatch() throws Exception {
        OutboundEndpoint endpoint = this.createTestOutboundEndpoint(null, null);
        ExceptionHandlingMessageProcessor mp = new ExceptionHandlingMessageProcessor();
        AbstractMessageProcessorTestCase.TestListener listener = new AbstractMessageProcessorTestCase.TestListener();
        mp.setListener((MessageProcessor)listener);
        MuleEvent event = this.createTestOutboundEvent();
        MuleEvent result = mp.process(event);
        Assert.assertSame((Object)event, (Object)listener.sensedEvent);
        Assert.assertSame((Object)event, (Object)result);
        Assert.assertNull((Object)this.exceptionListener.sensedException);
    }

    @Test
    public void testCatchRuntimeExceptionSync() throws Exception {
        OutboundEndpoint endpoint = this.createTestOutboundEndpoint(null, null);
        ExceptionHandlingMessageProcessor mp = new ExceptionHandlingMessageProcessor();
        mp.setListener((MessageProcessor)new AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr());
        MuleEvent event = this.createTestOutboundEvent(this.exceptionListener);
        MuleEvent resultEvent = mp.process(event);
        Assert.assertNotNull((Object)resultEvent);
        Assert.assertNotNull((String)"exception expected", (Object)resultEvent.getMessage().getExceptionPayload());
        Assert.assertTrue((boolean)(resultEvent.getMessage().getExceptionPayload().getException() instanceof IllegalStateException));
        Assert.assertEquals((Object)NullPayload.getInstance(), (Object)resultEvent.getMessage().getPayload());
        Assert.assertNotNull((Object)this.exceptionListener.sensedException);
    }

    @Test
    public void testCatchRuntimeExceptionAsync() throws Exception {
        OutboundEndpoint endpoint = this.createTestOutboundEndpoint(null, null, MessageExchangePattern.ONE_WAY, null);
        ExceptionHandlingMessageProcessor mp = new ExceptionHandlingMessageProcessor();
        mp.setListener((MessageProcessor)new AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr());
        MuleEvent event = this.createTestOutboundEvent(this.exceptionListener);
        MuleEvent resultEvent = mp.process(event);
        Assert.assertNotNull((Object)resultEvent);
        Assert.assertNotNull((String)"exception expected", (Object)resultEvent.getMessage().getExceptionPayload());
        Assert.assertTrue((boolean)(resultEvent.getMessage().getExceptionPayload().getException() instanceof IllegalStateException));
        Assert.assertEquals((Object)NullPayload.getInstance(), (Object)resultEvent.getMessage().getPayload());
        Assert.assertNotNull((Object)this.exceptionListener.sensedException);
    }

    @Test
    public void testCatchDispatchExceptionSync() throws Exception {
        OutboundEndpoint endpoint = this.createTestOutboundEndpoint(null, null);
        ExceptionHandlingMessageProcessor mp = new ExceptionHandlingMessageProcessor();
        mp.setListener((MessageProcessor)new AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr());
        MuleEvent event = this.createTestOutboundEvent(this.exceptionListener);
        MuleEvent resultEvent = mp.process(event);
        Assert.assertNotNull((Object)resultEvent);
        Assert.assertNotNull((String)"exception expected", (Object)resultEvent.getMessage().getExceptionPayload());
        Assert.assertTrue((boolean)(resultEvent.getMessage().getExceptionPayload().getException() instanceof IllegalStateException));
        Assert.assertEquals((Object)NullPayload.getInstance(), (Object)resultEvent.getMessage().getPayload());
        Assert.assertNotNull((Object)this.exceptionListener.sensedException);
    }

    @Test
    public void testCatchDispatchExceptionAsync() throws Exception {
        OutboundEndpoint endpoint = this.createTestOutboundEndpoint(null, null, MessageExchangePattern.ONE_WAY, null);
        ExceptionHandlingMessageProcessor mp = new ExceptionHandlingMessageProcessor();
        mp.setListener((MessageProcessor)new AbstractMessageProcessorTestCase.ExceptionThrowingMessageProcessr());
        MuleEvent event = this.createTestOutboundEvent(this.exceptionListener);
        MuleEvent resultEvent = mp.process(event);
        Assert.assertNotNull((Object)resultEvent);
        Assert.assertNotNull((String)"exception expected", (Object)resultEvent.getMessage().getExceptionPayload());
        Assert.assertTrue((boolean)(resultEvent.getMessage().getExceptionPayload().getException() instanceof IllegalStateException));
        Assert.assertEquals((Object)NullPayload.getInstance(), (Object)resultEvent.getMessage().getPayload());
        Assert.assertNotNull((Object)this.exceptionListener.sensedException);
    }
}

