/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.chain;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.ProcessorExecutor;
import org.mule.execution.MessageProcessorExecutionTemplate;
import org.mule.processor.BlockingProcessorExecutor;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class BlockingProcessorExecutorTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected MuleContext muleContext;
    @Mock
    protected MuleEvent event;
    @Mock
    protected MessageProcessorExecutionTemplate executionTemplate;
    protected static String A = "a";
    protected static String B = "b";
    protected static String C = "c";
    protected static String RESULT = A + B + C;
    protected SensingNullMessageProcessor processor1 = new SensingNullMessageProcessor(A);
    protected SensingNullMessageProcessor processor2 = new SensingNullMessageProcessor(B);
    protected SensingNullMessageProcessor processor3 = new SensingNullMessageProcessor(C);
    protected List<MessageProcessor> processors = new ArrayList<MessageProcessor>();

    @Before
    public void before() throws MessagingException {
        this.processors.add(this.processor1);
        this.processors.add(this.processor2);
        this.processors.add(this.processor3);
        Mockito.when((Object)this.event.getExchangePattern()).thenReturn((Object)MessageExchangePattern.REQUEST_RESPONSE);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", this.muleContext);
        Mockito.when((Object)this.event.getId()).thenReturn((Object)RandomStringUtils.randomNumeric((int)3));
        Mockito.when((Object)this.event.getMessage()).thenReturn((Object)message);
        Mockito.when((Object)this.event.getMuleContext()).thenReturn((Object)this.muleContext);
        Mockito.when((Object)this.executionTemplate.execute((MessageProcessor)Matchers.any(MessageProcessor.class), (MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new Answer<MuleEvent>(){

            public MuleEvent answer(InvocationOnMock invocation) throws Throwable {
                return ((MessageProcessor)invocation.getArguments()[0]).process((MuleEvent)invocation.getArguments()[1]);
            }
        });
    }

    @Test
    public void executeRequestResponse() throws MuleException {
        Mockito.when((Object)this.event.getExchangePattern()).thenReturn((Object)MessageExchangePattern.REQUEST_RESPONSE);
        Mockito.when((Object)this.event.isSynchronous()).thenReturn((Object)true);
        this.assertBlockingExecution(this.processors);
    }

    @Test
    public void executeRequestResponseNonBlocking() throws MuleException, InterruptedException {
        Mockito.when((Object)this.event.getExchangePattern()).thenReturn((Object)MessageExchangePattern.REQUEST_RESPONSE);
        Mockito.when((Object)this.event.isSynchronous()).thenReturn((Object)false);
        Mockito.when((Object)this.event.isAllowNonBlocking()).thenReturn((Object)true);
        this.assertBlockingExecution(this.processors);
    }

    @Test
    public void executeOneWay() throws MuleException {
        Mockito.when((Object)this.event.getExchangePattern()).thenReturn((Object)MessageExchangePattern.ONE_WAY);
        Mockito.when((Object)this.event.isSynchronous()).thenReturn((Object)false);
        this.assertBlockingExecution(this.processors);
    }

    protected void assertBlockingExecution(List<MessageProcessor> processors) throws MuleException {
        ProcessorExecutor executor = this.createProcessorExecutor(processors);
        if (this.event.getExchangePattern() == MessageExchangePattern.REQUEST_RESPONSE) {
            Assert.assertThat((Object)executor.execute().getMessageAsString(), (Matcher)CoreMatchers.equalTo((Object)RESULT));
        } else {
            Assert.assertThat((Object)executor.execute(), (Matcher)CoreMatchers.equalTo((Object)this.event));
        }
        Assert.assertThat((Object)this.processor1.event, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.processor1.thread, (Matcher)CoreMatchers.equalTo((Object)Thread.currentThread()));
        Assert.assertThat((Object)this.processor2.event, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.processor2.thread, (Matcher)CoreMatchers.equalTo((Object)Thread.currentThread()));
        Assert.assertThat((Object)this.processor3.event, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.processor3.thread, (Matcher)CoreMatchers.equalTo((Object)Thread.currentThread()));
    }

    protected ProcessorExecutor createProcessorExecutor(List<MessageProcessor> processors) {
        return new BlockingProcessorExecutor(this.event, processors, this.executionTemplate, true);
    }
}

