/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.registry.RegistrationException;
import org.mule.registry.AbstractLifecycleTracker;
import org.mule.registry.TransientRegistry;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class TransientRegistryTestCase
extends AbstractMuleContextTestCase {
    private static final String LIFECYCLE_PHASES = "[setMuleContext, initialise, start, stop, dispose]";

    @Test
    public void testObjectLifecycle() throws Exception {
        muleContext.start();
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker);
        muleContext.dispose();
        Assert.assertEquals((Object)LIFECYCLE_PHASES, (Object)tracker.getTracker().toString());
    }

    @Test
    public void testObjectLifecycleDoubleRegistration() throws Exception {
        muleContext.start();
        InterfaceBasedTracker tracker1 = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker1);
        InterfaceBasedTracker tracker2 = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker2);
        InterfaceBasedTracker tracker3 = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker3);
        muleContext.dispose();
        Assert.assertEquals((Object)LIFECYCLE_PHASES, (Object)tracker1.getTracker().toString());
        Assert.assertEquals((Object)LIFECYCLE_PHASES, (Object)tracker2.getTracker().toString());
        Assert.assertEquals((Object)LIFECYCLE_PHASES, (Object)tracker3.getTracker().toString());
    }

    @Test
    public void testJSR250ObjectLifecycle() throws Exception {
        muleContext.start();
        JSR250ObjectLifecycleTracker tracker = new JSR250ObjectLifecycleTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker);
        muleContext.dispose();
        Assert.assertEquals((Object)"[setMuleContext, initialise, dispose]", (Object)tracker.getTracker().toString());
    }

    @Test
    public void testObjectLifecycleStates() throws Exception {
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker);
        Assert.assertEquals((Object)"[setMuleContext, initialise]", (Object)tracker.getTracker().toString());
        try {
            muleContext.initialise();
            Assert.fail((String)"context already initialised");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        muleContext.start();
        Assert.assertEquals((Object)"[setMuleContext, initialise, start]", (Object)tracker.getTracker().toString());
        try {
            muleContext.start();
            Assert.fail((String)"context already started");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        muleContext.stop();
        Assert.assertEquals((Object)"[setMuleContext, initialise, start, stop]", (Object)tracker.getTracker().toString());
        try {
            muleContext.stop();
            Assert.fail((String)"context already stopped");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        muleContext.dispose();
        Assert.assertEquals((Object)LIFECYCLE_PHASES, (Object)tracker.getTracker().toString());
        try {
            muleContext.dispose();
            Assert.fail((String)"context already disposed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testObjectLifecycleRestart() throws Exception {
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker);
        muleContext.start();
        Assert.assertEquals((Object)"[setMuleContext, initialise, start]", (Object)tracker.getTracker().toString());
        muleContext.stop();
        Assert.assertEquals((Object)"[setMuleContext, initialise, start, stop]", (Object)tracker.getTracker().toString());
        muleContext.start();
        Assert.assertEquals((Object)"[setMuleContext, initialise, start, stop, start]", (Object)tracker.getTracker().toString());
        muleContext.dispose();
        Assert.assertEquals((Object)"[setMuleContext, initialise, start, stop, start, stop, dispose]", (Object)tracker.getTracker().toString());
    }

    @Test
    public void testLifecycleStateOutOfSequenceDisposeFirstWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.fireLifecycle("dispose");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        try {
            reg.registerObject("test", (Object)tracker);
            Assert.fail((String)"Cannot register objects on a disposed registry");
        }
        catch (RegistrationException registrationException) {
            // empty catch block
        }
    }

    @Test
    public void testLifecycleStateOutOfSequenceStartFirst() throws Exception {
        muleContext.start();
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker);
        Assert.assertEquals((Object)"[setMuleContext, initialise, start]", (Object)tracker.getTracker().toString());
        muleContext.dispose();
        Assert.assertEquals((Object)LIFECYCLE_PHASES, (Object)tracker.getTracker().toString());
    }

    @Test
    public void testLifecycleStateOutOfSequenceStopFirst() throws Exception {
        try {
            muleContext.stop();
            Assert.fail((String)"Cannot not stop the context if not started");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        muleContext.start();
        muleContext.stop();
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker);
        Assert.assertEquals((Object)"[setMuleContext, initialise]", (Object)tracker.getTracker().toString());
        muleContext.dispose();
        Assert.assertEquals((Object)"[setMuleContext, initialise, dispose]", (Object)tracker.getTracker().toString());
    }

    @Test
    public void testLifecycleStateOutOfSequenceDisposeFirst() throws Exception {
        muleContext.dispose();
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        try {
            muleContext.getRegistry().registerObject("test", (Object)tracker);
            Assert.fail((String)"cannot register objects on a disposed registry");
        }
        catch (RegistrationException registrationException) {
            // empty catch block
        }
    }

    public class JSR250ObjectLifecycleTracker
    implements MuleContextAware {
        private final List<String> tracker = new ArrayList<String>();

        public List<String> getTracker() {
            return this.tracker;
        }

        public void setMuleContext(MuleContext context) {
            this.tracker.add("setMuleContext");
        }

        @PostConstruct
        public void init() {
            this.tracker.add("initialise");
        }

        @PreDestroy
        public void dispose() {
            this.tracker.add("dispose");
        }
    }

    public class InterfaceBasedTracker
    extends AbstractLifecycleTracker {
    }
}

