/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RoutePathNotFoundException;
import org.mule.api.routing.filter.Filter;
import org.mule.management.stats.RouterStatistics;
import org.mule.routing.ChoiceRouter;
import org.mule.routing.filters.EqualsFilter;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.mule.TestMessageProcessor;

public class ChoiceRouterTestCase
extends AbstractMuleContextTestCase {
    private ChoiceRouter choiceRouter;

    public ChoiceRouterTestCase() {
        this.setDisposeContextPerClass(true);
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.choiceRouter = new ChoiceRouter();
    }

    @Test
    public void testNoRoute() throws Exception {
        try {
            this.choiceRouter.process(ChoiceRouterTestCase.getTestEvent("foo"));
            Assert.fail((String)"should have got a MuleException");
        }
        catch (MuleException me) {
            Assert.assertTrue((boolean)(me instanceof RoutePathNotFoundException));
        }
    }

    @Test
    public void testOnlyDefaultRoute() throws Exception {
        this.choiceRouter.setDefaultRoute((MessageProcessor)new TestMessageProcessor("default"));
        Assert.assertEquals((Object)"foo:default", (Object)this.choiceRouter.process(ChoiceRouterTestCase.getTestEvent("foo")).getMessageAsString());
    }

    @Test
    public void testNoMatchingNorDefaultRoute() throws Exception {
        try {
            this.choiceRouter.addRoute((MessageProcessor)new TestMessageProcessor("bar"), (Filter)new EqualsFilter((Object)"zap"));
            this.choiceRouter.process(ChoiceRouterTestCase.getTestEvent("foo"));
            Assert.fail((String)"should have got a MuleException");
        }
        catch (MuleException me) {
            Assert.assertTrue((boolean)(me instanceof RoutePathNotFoundException));
        }
    }

    @Test
    public void testNoMatchingRouteWithDefaultRoute() throws Exception {
        this.choiceRouter.addRoute((MessageProcessor)new TestMessageProcessor("bar"), (Filter)new EqualsFilter((Object)"zap"));
        this.choiceRouter.setDefaultRoute((MessageProcessor)new TestMessageProcessor("default"));
        Assert.assertEquals((Object)"foo:default", (Object)this.choiceRouter.process(ChoiceRouterTestCase.getTestEvent("foo")).getMessageAsString());
    }

    @Test
    public void testMatchingRouteWithDefaultRoute() throws Exception {
        this.choiceRouter.addRoute((MessageProcessor)new TestMessageProcessor("bar"), (Filter)new EqualsFilter((Object)"zap"));
        this.choiceRouter.setDefaultRoute((MessageProcessor)new TestMessageProcessor("default"));
        Assert.assertEquals((Object)"zap:bar", (Object)this.choiceRouter.process(ChoiceRouterTestCase.getTestEvent("zap")).getMessageAsString());
    }

    @Test
    public void testMatchingRouteWithStatistics() throws Exception {
        this.choiceRouter.addRoute((MessageProcessor)new TestMessageProcessor("bar"), (Filter)new EqualsFilter((Object)"zap"));
        this.choiceRouter.setRouterStatistics(new RouterStatistics(2));
        Assert.assertEquals((Object)"zap:bar", (Object)this.choiceRouter.process(ChoiceRouterTestCase.getTestEvent("zap")).getMessageAsString());
    }

    @Test
    public void testAddAndDeleteRoute() throws Exception {
        try {
            TestMessageProcessor mp = new TestMessageProcessor("bar");
            this.choiceRouter.addRoute((MessageProcessor)mp, (Filter)new EqualsFilter((Object)"zap"));
            this.choiceRouter.removeRoute((MessageProcessor)mp);
            this.choiceRouter.setRouterStatistics(new RouterStatistics(2));
            this.choiceRouter.process(ChoiceRouterTestCase.getTestEvent("zap"));
            Assert.fail((String)"should have got a MuleException");
        }
        catch (MuleException me) {
            Assert.assertTrue((boolean)(me instanceof RoutePathNotFoundException));
        }
    }

    @Test
    public void testUpdateRoute() throws Exception {
        TestMessageProcessor mp = new TestMessageProcessor("bar");
        this.choiceRouter.addRoute((MessageProcessor)mp, (Filter)new EqualsFilter((Object)"paz"));
        this.choiceRouter.updateRoute((MessageProcessor)mp, (Filter)new EqualsFilter((Object)"zap"));
        Assert.assertEquals((Object)"zap:bar", (Object)this.choiceRouter.process(ChoiceRouterTestCase.getTestEvent("zap")).getMessageAsString());
    }

    @Test
    public void testRemovingUpdatingMissingRoutes() {
        this.choiceRouter.updateRoute((MessageProcessor)new TestMessageProcessor("bar"), (Filter)new EqualsFilter((Object)"zap"));
        this.choiceRouter.removeRoute((MessageProcessor)new TestMessageProcessor("rab"));
    }
}

