/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.service.Service;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.routing.IdempotentMessageFilter;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class IdempotentMessageFilterMule6079TestCase
extends AbstractMuleContextTestCase {
    private MuleSession session;
    private Service service;
    private InboundEndpoint inboundEndpoint;
    private ObjectStore<String> objectStore;
    private IdempotentMessageFilter idempotentMessageFilter;
    private Integer processedEvents = 0;
    private Boolean errorHappenedInChildThreads = false;

    @Test
    public void testRaceConditionOnAcceptAndProcess() throws Exception {
        this.inboundEndpoint = IdempotentMessageFilterMule6079TestCase.getTestInboundEndpoint("Test", "test://Test?exchangePattern=one-way");
        this.service = IdempotentMessageFilterMule6079TestCase.getTestService();
        this.session = (MuleSession)Mockito.mock(MuleSession.class);
        Mockito.when((Object)this.session.getFlowConstruct()).thenReturn((Object)this.service);
        CountDownLatch cdl = new CountDownLatch(2);
        this.objectStore = new RaceConditionEnforcingObjectStore(cdl);
        this.idempotentMessageFilter = new IdempotentMessageFilter();
        this.idempotentMessageFilter.setIdExpression("#[header:id]");
        this.idempotentMessageFilter.setFlowConstruct((FlowConstruct)this.service);
        this.idempotentMessageFilter.setThrowOnUnaccepted(false);
        this.idempotentMessageFilter.setStorePrefix("foo");
        this.idempotentMessageFilter.setStore(this.objectStore);
        Thread t1 = new Thread((Runnable)new TestForRaceConditionRunnable(), "thread1");
        Thread t2 = new Thread((Runnable)new TestForRaceConditionRunnable(), "thread2");
        t1.start();
        t2.start();
        t1.join(5000L);
        t2.join(5000L);
        Assert.assertFalse((String)"Exception in child threads", (boolean)this.errorHappenedInChildThreads);
        Assert.assertEquals((String)"None or more than one message was processed by IdempotentMessageFilter", (Object)new Integer(1), (Object)this.processedEvents);
    }

    private class RaceConditionEnforcingObjectStore
    implements ObjectStore<String> {
        protected CountDownLatch barrier;
        Map<Serializable, String> map = new TreeMap<Serializable, String>();

        public RaceConditionEnforcingObjectStore(CountDownLatch latch) {
            this.barrier = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Serializable key) throws ObjectStoreException {
            boolean containsKey;
            if (key == null) {
                throw new ObjectStoreException();
            }
            RaceConditionEnforcingObjectStore raceConditionEnforcingObjectStore = this;
            synchronized (raceConditionEnforcingObjectStore) {
                containsKey = this.map.containsKey(key);
                if (containsKey) {
                    this.barrier.countDown();
                }
            }
            return containsKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void store(Serializable key, String value) throws ObjectStoreException {
            boolean wasAdded;
            if (key == null) {
                throw new ObjectStoreException();
            }
            Map<Serializable, String> map = this.map;
            synchronized (map) {
                wasAdded = this.map.containsKey(key);
                this.map.put(key, value);
            }
            this.barrier.countDown();
            try {
                this.barrier.await();
            }
            catch (Exception e) {
                Boolean bl = IdempotentMessageFilterMule6079TestCase.this.errorHappenedInChildThreads;
                synchronized (bl) {
                    IdempotentMessageFilterMule6079TestCase.this.errorHappenedInChildThreads = true;
                }
            }
            if (wasAdded) {
                throw new ObjectAlreadyExistsException();
            }
        }

        public String retrieve(Serializable key) throws ObjectStoreException {
            return null;
        }

        public String remove(Serializable key) throws ObjectStoreException {
            return null;
        }

        public boolean isPersistent() {
            return false;
        }

        public void clear() throws ObjectStoreException {
            this.map.clear();
        }
    }

    private class TestForRaceConditionRunnable
    implements Runnable {
        private TestForRaceConditionRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Comparable<Boolean> comparable;
            DefaultMuleMessage okMessage = new DefaultMuleMessage((Object)"OK", muleContext);
            okMessage.setOutboundProperty("id", (Object)"1");
            DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)okMessage, IdempotentMessageFilterMule6079TestCase.this.inboundEndpoint, IdempotentMessageFilterMule6079TestCase.this.session);
            try {
                event = IdempotentMessageFilterMule6079TestCase.this.idempotentMessageFilter.process((MuleEvent)event);
            }
            catch (Throwable e) {
                e.printStackTrace();
                comparable = IdempotentMessageFilterMule6079TestCase.this.errorHappenedInChildThreads;
                synchronized (comparable) {
                    IdempotentMessageFilterMule6079TestCase.this.errorHappenedInChildThreads = true;
                }
            }
            if (event != null) {
                Integer n = IdempotentMessageFilterMule6079TestCase.this.processedEvents;
                synchronized (n) {
                    comparable = IdempotentMessageFilterMule6079TestCase.this.processedEvents;
                    Integer n2 = IdempotentMessageFilterMule6079TestCase.this.processedEvents = IdempotentMessageFilterMule6079TestCase.this.processedEvents + 1;
                }
            }
        }
    }
}

