/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.junit.Assert;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.routing.MessageFilter;
import org.mule.routing.filters.EqualsFilter;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MessageFilterTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testFilterPass() throws Exception {
        MessageFilter mp = new MessageFilter((Filter)new EqualsFilter((Object)"Test Message"), false, null);
        SensingNullMessageProcessor listener = this.getSensingNullMessageProcessor();
        mp.setListener((MessageProcessor)listener);
        MuleEvent inEvent = MessageFilterTestCase.getTestEvent("Test Message");
        MuleEvent resultEvent = mp.process(inEvent);
        Assert.assertNotNull((Object)listener.event);
        Assert.assertSame((Object)inEvent, (Object)listener.event);
        Assert.assertEquals((Object)inEvent, (Object)resultEvent);
    }

    @Test
    public void testFilterFail() throws Exception {
        MessageFilter mp = new MessageFilter((Filter)new EqualsFilter(null), false, null);
        SensingNullMessageProcessor out = this.getSensingNullMessageProcessor();
        mp.setListener((MessageProcessor)out);
        MuleEvent inEvent = MessageFilterTestCase.getTestEvent("Test Message");
        MuleEvent resultEvent = mp.process(inEvent);
        Assert.assertNull((Object)out.event);
        Assert.assertNull((Object)resultEvent);
    }

    @Test
    public void testFilterPassUnacceptedMP() throws Exception {
        MessageFilter mp = new MessageFilter((Filter)new EqualsFilter((Object)"Test Message"), false, null);
        SensingNullMessageProcessor out = this.getSensingNullMessageProcessor();
        SensingNullMessageProcessor unaccepted = this.getSensingNullMessageProcessor();
        mp.setListener((MessageProcessor)out);
        mp.setUnacceptedMessageProcessor((MessageProcessor)unaccepted);
        MuleEvent inEvent = MessageFilterTestCase.getTestEvent("Test Message");
        MuleEvent resultEvent = mp.process(inEvent);
        Assert.assertNotNull((Object)out.event);
        Assert.assertSame((Object)inEvent, (Object)out.event);
        Assert.assertEquals((Object)inEvent, (Object)resultEvent);
        Assert.assertNull((Object)unaccepted.event);
    }

    @Test
    public void testFilterFailUnacceptedMP() throws Exception {
        SensingNullMessageProcessor unaccepted = this.getSensingNullMessageProcessor();
        MessageFilter mp = new MessageFilter((Filter)new EqualsFilter(null), false, (MessageProcessor)unaccepted);
        SensingNullMessageProcessor out = this.getSensingNullMessageProcessor();
        mp.setListener((MessageProcessor)out);
        MuleEvent inEvent = MessageFilterTestCase.getTestEvent((Object)"Test Message", MessageExchangePattern.ONE_WAY);
        MuleEvent resultEvent = mp.process(inEvent);
        Assert.assertNull((Object)out.event);
        Assert.assertSame((Object)VoidMuleEvent.getInstance(), (Object)resultEvent);
        Assert.assertNotNull((Object)unaccepted.event);
        Assert.assertSame((Object)inEvent, (Object)unaccepted.event);
    }
}

