/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service;

import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.api.source.MessageSource;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.routing.MessageFilter;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.source.StartableCompositeMessageSource;
import org.mule.source.StartableCompositeMessageSourceTestCase;

public class ServiceCompositeMessageSourceTestCase
extends StartableCompositeMessageSourceTestCase {
    @Override
    protected StartableCompositeMessageSource getCompositeSource() {
        return new ServiceCompositeMessageSource();
    }

    @Test
    public void testInboundRouters() throws MuleException {
        ServiceCompositeMessageSource serviceCompositeMessageSource = (ServiceCompositeMessageSource)this.compositeSource;
        serviceCompositeMessageSource.setListener((MessageProcessor)this.listener);
        serviceCompositeMessageSource.addMessageProcessor((MessageProcessor)new AppendingInterceptingMessageProcessor("one"));
        serviceCompositeMessageSource.addMessageProcessor((MessageProcessor)new AppendingInterceptingMessageProcessor("two"));
        serviceCompositeMessageSource.addSource((MessageSource)this.source);
        serviceCompositeMessageSource.initialise();
        serviceCompositeMessageSource.start();
        this.source.triggerSource();
        Assert.assertEquals((Object)"Test Messageonetwo", (Object)this.listener.event.getMessageAsString());
    }

    @Test
    public void testInboundRouterCatchAll() throws MuleException {
        ServiceCompositeMessageSource serviceCompositeMessageSource = (ServiceCompositeMessageSource)this.compositeSource;
        serviceCompositeMessageSource.setListener((MessageProcessor)this.listener);
        serviceCompositeMessageSource.setCatchAllStrategy((MessageProcessor)this.listener2);
        serviceCompositeMessageSource.addMessageProcessor((MessageProcessor)new AppendingInterceptingMessageProcessor("one"));
        serviceCompositeMessageSource.addMessageProcessor((MessageProcessor)new TestMessageFilter(false));
        serviceCompositeMessageSource.addSource((MessageSource)this.source);
        serviceCompositeMessageSource.initialise();
        serviceCompositeMessageSource.start();
        this.source.triggerSource();
        Assert.assertNull((Object)this.listener.event);
        Assert.assertNotNull((Object)this.listener2.event);
        Assert.assertEquals((Object)"Test Messageone", (Object)this.listener2.event.getMessageAsString());
    }

    class TestMessageFilter
    extends MessageFilter {
        public TestMessageFilter(final boolean accept) {
            super(new Filter(){

                public boolean accept(MuleMessage message) {
                    return accept;
                }
            });
        }
    }

    class AppendingInterceptingMessageProcessor
    extends AbstractInterceptingMessageProcessor {
        String appendString;

        public AppendingInterceptingMessageProcessor(String appendString) {
            this.appendString = appendString;
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            return this.processNext((MuleEvent)new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)(event.getMessage().getPayload() + this.appendString), muleContext), event));
        }
    }
}

