/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.model.Model;
import org.mule.api.service.Service;
import org.mule.api.source.CompositeMessageSource;
import org.mule.api.source.MessageSource;
import org.mule.api.transport.Connector;
import org.mule.config.QueueProfile;
import org.mule.model.seda.SedaModel;
import org.mule.model.seda.SedaService;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.transport.AbstractConnector;

public class ServiceTestCase
extends AbstractMuleContextTestCase {
    private Connector testConnector;
    private Service service;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.testConnector = new TestConnector(muleContext);
        this.testConnector.setName("customTestConnector");
        muleContext.getRegistry().registerConnector(this.testConnector);
        InboundEndpoint inboundEndpoint1 = muleContext.getEndpointFactory().getInboundEndpoint("test://test1?connector=customTestConnector");
        InboundEndpoint inboundEndpoint2 = muleContext.getEndpointFactory().getInboundEndpoint("test://test2?connector=customTestConnector");
        this.service = new SedaService(muleContext);
        this.service.setName("testService");
        ((CompositeMessageSource)this.service.getMessageSource()).addSource((MessageSource)inboundEndpoint1);
        ((CompositeMessageSource)this.service.getMessageSource()).addSource((MessageSource)inboundEndpoint2);
        SedaModel model = new SedaModel();
        model.setMuleContext(muleContext);
        model.initialise();
        this.service.setModel((Model)model);
        QueueProfile queueProfile = QueueProfile.newInstancePersistingToDefaultMemoryQueueStore((MuleContext)muleContext);
        ((SedaService)this.service).setQueueProfile(queueProfile);
        muleContext.getRegistry().registerService(this.service);
    }

    @Override
    protected void doTearDown() throws Exception {
        muleContext.getRegistry().unregisterObject(this.service.getName(), (Object)1);
    }

    @Test
    public void testUnregisterListenersOnServiceDisposal() throws Exception {
        muleContext.start();
        Assert.assertEquals((long)2L, (long)((AbstractConnector)this.testConnector).getReceivers().size());
        this.service.stop();
        this.service.dispose();
        Assert.assertEquals((long)0L, (long)((AbstractConnector)this.testConnector).getReceivers().size());
    }

    @Test
    public void testUnregisterListenersOnServiceStop() throws Exception {
        muleContext.start();
        Assert.assertEquals((long)2L, (long)((AbstractConnector)this.testConnector).getReceivers().size());
        this.service.stop();
        Assert.assertEquals((long)0L, (long)((AbstractConnector)this.testConnector).getReceivers().size());
    }
}

