/*
 * Decompiled with CFR 0.152.
 */
package org.mule.streaming;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.streaming.Consumer;
import org.mule.streaming.ConsumerIterator;
import org.mule.streaming.ListConsumer;
import org.mule.streaming.PagingDelegate;
import org.mule.streaming.PagingDelegateProducer;
import org.mule.streaming.Producer;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ConsumerIteratorTestCase {
    private static final int PAGE_SIZE = 100;
    private static final int TOP = 3000;
    private PagingDelegate<String> delegate = new PagingDelegate<String>(){
        long counter = 0L;

        public List<String> getPage() {
            if (this.counter < 3000L) {
                ArrayList<String> page = new ArrayList<String>(100);
                for (int i = 0; i < 100; ++i) {
                    ++this.counter;
                    String value = RandomStringUtils.randomAlphabetic((int)5000);
                    page.add(value);
                }
                return page;
            }
            return null;
        }

        public void close() throws MuleException {
        }

        public int getTotalResults() {
            return 3000;
        }
    };

    @Test
    public void iterateStreaming() throws Exception {
        ConsumerIterator<String> it = this.newIterator();
        int count = 0;
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        Assert.assertEquals((long)count, (long)3000L);
        it.close();
    }

    @Test
    public void closedIterator() throws Exception {
        ConsumerIterator<String> it = this.newIterator();
        it.close();
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void closedConsumer() throws Exception {
        PagingDelegateProducer producer = new PagingDelegateProducer(this.delegate);
        ListConsumer consumer = new ListConsumer((Producer)producer);
        ConsumerIterator it = new ConsumerIterator((Consumer)consumer);
        consumer.close();
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void size() throws Exception {
        ConsumerIterator<String> it = this.newIterator();
        Assert.assertEquals((long)it.size(), (long)3000L);
    }

    private ConsumerIterator<String> newIterator() {
        PagingDelegateProducer producer = new PagingDelegateProducer(this.delegate);
        ListConsumer consumer = new ListConsumer((Producer)producer);
        ConsumerIterator it = new ConsumerIterator((Consumer)consumer);
        return it;
    }
}

