/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.matcher;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.mule.api.transformer.DataType;

public class DataTypeMatcher
extends TypeSafeMatcher<DataType> {
    private final Class type;
    private final String mimeType;
    private final String encoding;

    public DataTypeMatcher(Class type, String mimeType, String encoding) {
        this.type = type;
        this.mimeType = mimeType;
        this.encoding = encoding;
    }

    protected boolean matchesSafely(DataType dataType) {
        boolean sameEncoding;
        boolean sameType;
        boolean bl = this.type == null ? dataType.getType() == null : (sameType = this.type.equals(dataType.getType()));
        boolean bl2 = this.encoding == null ? dataType.getEncoding() == null : (sameEncoding = this.encoding.equals(dataType.getEncoding()));
        boolean sameMimeType = this.mimeType == null ? dataType.getMimeType() == null : this.mimeType.equals(dataType.getMimeType());
        return sameType && sameEncoding && sameMimeType;
    }

    public void describeTo(Description description) {
        description.appendText("a dataType with type = " + this.type.getName() + ", mimeType= " + this.mimeType + ", encoding=" + this.encoding);
    }

    public static Matcher<DataType> like(Class type, String mimeType, String encoding) {
        return new DataTypeMatcher(type, mimeType, encoding);
    }

    public static Matcher<DataType> like(DataType dataType) {
        return new DataTypeMatcher(dataType.getType(), dataType.getMimeType(), dataType.getEncoding());
    }
}

