/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import java.util.Random;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transaction.XaTransaction;
import org.mule.util.xa.XaResourceFactoryHolder;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class XaTransactionTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext mockMuleContext;
    @Mock
    private TransactionManager mockTransactionManager;
    @Mock
    private XaResourceFactoryHolder mockXaResourceFactoryHolder1;
    @Mock
    private XaResourceFactoryHolder mockXaResourceFactoryHolder2;
    @Mock
    private XAResource mockXaResource;

    @Before
    public void setUpMuleContext() {
        Mockito.when((Object)this.mockMuleContext.getTransactionManager()).thenReturn((Object)this.mockTransactionManager);
        Mockito.when((Object)this.mockMuleContext.getConfiguration().getId()).thenReturn((Object)"appName");
    }

    @Test
    public void overcomeBadHashCodeImplementations() throws Exception {
        XaTransaction xaTransaction = new XaTransaction(this.mockMuleContext);
        BadHashCodeImplementation badHashCodeImplementation = new BadHashCodeImplementation();
        Object resource = new Object();
        xaTransaction.bindResource((Object)badHashCodeImplementation, resource);
        Assert.assertThat((Object)xaTransaction.hasResource((Object)badHashCodeImplementation), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)xaTransaction.getResource((Object)badHashCodeImplementation), (Matcher)Is.is((Object)resource));
    }

    @Test
    public void recognizeDifferentWrappersOfSameResource() throws Exception {
        XaTransaction xaTransaction = new XaTransaction(this.mockMuleContext);
        Object resourceFactory = new Object();
        Object resource = new Object();
        Mockito.when((Object)this.mockXaResourceFactoryHolder1.getHoldObject()).thenReturn(resourceFactory);
        Mockito.when((Object)this.mockXaResourceFactoryHolder2.getHoldObject()).thenReturn(resourceFactory);
        xaTransaction.bindResource((Object)this.mockXaResourceFactoryHolder1, resource);
        Assert.assertThat((Object)xaTransaction.hasResource((Object)this.mockXaResourceFactoryHolder1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)xaTransaction.hasResource((Object)this.mockXaResourceFactoryHolder2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)xaTransaction.getResource((Object)this.mockXaResourceFactoryHolder2), (Matcher)Is.is((Object)resource));
    }

    @Test
    public void isRollbackOnly() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)tx.getStatus()).thenReturn((Object)0).thenReturn((Object)3).thenReturn((Object)1).thenReturn((Object)4).thenReturn((Object)9);
        Mockito.when((Object)this.mockTransactionManager.getTransaction()).thenReturn((Object)tx);
        XaTransaction xaTransaction = new XaTransaction(this.mockMuleContext);
        xaTransaction.begin();
        junit.framework.Assert.assertFalse((boolean)xaTransaction.isRollbackOnly());
        junit.framework.Assert.assertFalse((boolean)xaTransaction.isRollbackOnly());
        junit.framework.Assert.assertTrue((boolean)xaTransaction.isRollbackOnly());
        junit.framework.Assert.assertTrue((boolean)xaTransaction.isRollbackOnly());
        junit.framework.Assert.assertTrue((boolean)xaTransaction.isRollbackOnly());
    }

    @Test
    public void setTxTimeoutWhenEnlistingResource() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)this.mockTransactionManager.getTransaction()).thenReturn((Object)tx);
        XaTransaction xaTransaction = new XaTransaction(this.mockMuleContext);
        int timeoutValue = 1500;
        int timeoutValueInSeconds = 1;
        xaTransaction.setTimeout(timeoutValue);
        xaTransaction.begin();
        xaTransaction.enlistResource(this.mockXaResource);
        ((XAResource)Mockito.verify((Object)this.mockXaResource)).setTransactionTimeout(timeoutValueInSeconds);
    }

    private class BadHashCodeImplementation {
        private BadHashCodeImplementation() {
        }

        public int hashCode() {
            return new Random(System.nanoTime()).nextInt();
        }
    }
}

