/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.transformer.AbstractDiscoverableTransformer;
import org.mule.transformer.types.DataTypeFactory;

@SmallTest
public class TransformerResolutionTestCase
extends AbstractMuleContextTestCase {
    public static final DataType<Fruit> FRUIT_DATA_TYPE = DataTypeFactory.create(Fruit.class);
    public static final DataType<Orange> ORANGE_DATA_TYPE = DataTypeFactory.create(Orange.class);
    public static final DataType<Apple> APPLE_DATA_TYPE = DataTypeFactory.create(Apple.class);

    @Test
    public void resolvesMultipleApplicableTransformers() throws MuleException {
        muleContext.getRegistry().registerTransformer((Transformer)new StringToOrange());
        muleContext.getRegistry().registerTransformer((Transformer)new StringToApple());
        muleContext.getRegistry().registerTransformer((Transformer)new StringToFruit());
        try {
            Transformer transformer = muleContext.getRegistry().lookupTransformer(DataTypeFactory.STRING, FRUIT_DATA_TYPE);
            Assert.assertTrue((String)String.format("Expected a %s transformer but got %s", StringToFruit.class.getName(), transformer.getClass().getName()), (boolean)(transformer instanceof StringToFruit));
        }
        catch (TransformerException e) {
            Assert.fail((String)"Unable to properly resolve transformer");
        }
    }

    protected class StringToApple
    extends AbstractStringToFruit {
        public StringToApple() {
            this.setReturnDataType(APPLE_DATA_TYPE);
        }
    }

    protected class StringToOrange
    extends AbstractStringToFruit {
        public StringToOrange() {
            this.setReturnDataType(ORANGE_DATA_TYPE);
        }
    }

    protected class StringToFruit
    extends AbstractStringToFruit {
        public StringToFruit() {
            this.setReturnDataType(FRUIT_DATA_TYPE);
        }
    }

    protected class AbstractStringToFruit
    extends AbstractDiscoverableTransformer {
        public AbstractStringToFruit() {
            this.registerSourceType(DataTypeFactory.STRING);
        }

        protected Object doTransform(Object src, String encoding) throws TransformerException {
            return new Orange();
        }
    }
}

