/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.internal.matchers.TypeSafeMatcher;
import org.mockito.Matchers;

public class WorkEventMatcher
extends TypeSafeMatcher<WorkEvent> {
    private Object source;
    private final Work work;
    private final int type;
    private final WorkException workException;
    private final long startDuration;

    public WorkEventMatcher(Object source, Work work, int type, WorkException workException, long startDuration) {
        this.source = source;
        this.work = work;
        this.type = type;
        this.workException = workException;
        this.startDuration = startDuration;
    }

    public boolean matchesSafely(WorkEvent workEvent) {
        return workEvent.getSource() == this.source && workEvent.getWork() == this.work && workEvent.getException() == this.workException && workEvent.getStartDuration() == this.startDuration && workEvent.getType() == this.type;
    }

    public void describeTo(Description description) {
        description.appendText(String.format("a WorkEvent for work '%s', type '%s', source '%s', exception '%s' and startDuration '%s'", this.work, this.type, this.source, this.workException, this.startDuration));
    }

    public static WorkEvent anAcceptedWorkEventFor(Object source, Work work, WorkException workException, long startDuration) {
        return (WorkEvent)Matchers.argThat((Matcher)new WorkEventMatcher(source, work, 1, workException, startDuration));
    }

    public static WorkEvent aCompletedWorkEventFor(Object source, Work work, WorkException workException, long startDuration) {
        return (WorkEvent)Matchers.argThat((Matcher)new WorkEventMatcher(source, work, 4, workException, startDuration));
    }

    public static WorkEvent aRejectedWorkEventFor(Object source, Work work, WorkException workException, long startDuration) {
        return (WorkEvent)Matchers.argThat((Matcher)new WorkEventMatcher(source, work, 2, workException, startDuration));
    }

    public static WorkEvent aStartedWorkEventFor(Object source, Work work, WorkException workException, long startDuration) {
        return (WorkEvent)Matchers.argThat((Matcher)new WorkEventMatcher(source, work, 3, workException, startDuration));
    }
}

