/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.polling.schedule;

import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.schedule.Scheduler;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.PollingReceiverWorker;
import org.mule.transport.polling.schedule.FixedFrequencyScheduler;
import org.mule.transport.polling.schedule.FixedFrequencySchedulerFactory;

public class FixedFrequencySchedulerFactoryTest {
    private AbstractPollingMessageReceiver receiver = (AbstractPollingMessageReceiver)Mockito.mock(AbstractPollingMessageReceiver.class);

    @Test
    public void testCreatesCorrectInstance() {
        FixedFrequencySchedulerFactory factory = new FixedFrequencySchedulerFactory();
        factory.setFrequency(300L);
        factory.setStartDelay(400L);
        factory.setTimeUnit(TimeUnit.DAYS);
        Scheduler scheduler = factory.doCreate("name", (Runnable)new PollingReceiverWorker(this.receiver));
        Assert.assertTrue((boolean)(scheduler instanceof FixedFrequencyScheduler));
        Assert.assertEquals((long)300L, (long)((FixedFrequencyScheduler)scheduler).getFrequency());
        Assert.assertEquals((Object)((Object)TimeUnit.DAYS), (Object)((Object)((FixedFrequencyScheduler)scheduler).getTimeUnit()));
        Assert.assertEquals((String)"name", (String)scheduler.getName());
    }

    @Test
    public void testDefaultValues() {
        FixedFrequencySchedulerFactory factory = new FixedFrequencySchedulerFactory();
        Scheduler scheduler = factory.doCreate("name", (Runnable)new PollingReceiverWorker(this.receiver));
        Assert.assertTrue((boolean)(scheduler instanceof FixedFrequencyScheduler));
        Assert.assertEquals((long)1000L, (long)((FixedFrequencyScheduler)scheduler).getFrequency());
        Assert.assertEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)((FixedFrequencyScheduler)scheduler).getTimeUnit()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeFrequency() {
        FixedFrequencySchedulerFactory factory = new FixedFrequencySchedulerFactory();
        factory.setFrequency(-1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeStartDelay() {
        FixedFrequencySchedulerFactory factory = new FixedFrequencySchedulerFactory();
        factory.setStartDelay(-1L);
    }
}

